/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor.metadata;

import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;

public class ItemMetadata
implements Comparable<ItemMetadata> {
    private final ItemType itemType;
    private final String name;
    private final String type;
    private final String description;
    private final String sourceType;
    private final String sourceMethod;
    private final Object defaultValue;
    private final boolean deprecated;

    ItemMetadata(ItemType itemType, String prefix, String name, String type, String sourceType, String sourceMethod, String description, Object defaultValue, boolean deprecated) {
        this.itemType = itemType;
        this.name = this.buildName(prefix, name);
        this.type = type;
        this.sourceType = sourceType;
        this.sourceMethod = sourceMethod;
        this.description = description;
        this.defaultValue = defaultValue;
        this.deprecated = deprecated;
    }

    private String buildName(String prefix, String name) {
        while (prefix != null && prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        StringBuilder fullName = new StringBuilder(prefix == null ? "" : prefix);
        if (fullName.length() > 0 && name != null) {
            fullName.append(".");
        }
        fullName.append(name == null ? "" : ConfigurationMetadata.toDashedCase(name));
        return fullName.toString();
    }

    public boolean isOfItemType(ItemType itemType) {
        return this.itemType == itemType;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceMethod() {
        return this.sourceMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        StringBuilder string = new StringBuilder(this.name);
        this.buildToStringProperty(string, "type", this.type);
        this.buildToStringProperty(string, "sourceType", this.sourceType);
        this.buildToStringProperty(string, "description", this.description);
        this.buildToStringProperty(string, "defaultValue", this.defaultValue);
        this.buildToStringProperty(string, "deprecated", this.deprecated);
        return string.toString();
    }

    protected final void buildToStringProperty(StringBuilder string, String property, Object value) {
        if (value != null) {
            string.append(" ").append(property).append(":").append(value);
        }
    }

    @Override
    public int compareTo(ItemMetadata o) {
        return this.getName().compareTo(o.getName());
    }

    public static ItemMetadata newGroup(String name, String type, String sourceType, String sourceMethod) {
        return new ItemMetadata(ItemType.GROUP, name, null, type, sourceType, sourceMethod, null, null, false);
    }

    public static ItemMetadata newProperty(String prefix, String name, String type, String sourceType, String sourceMethod, String description, Object defaultValue, boolean deprecated) {
        return new ItemMetadata(ItemType.PROPERTY, prefix, name, type, sourceType, sourceMethod, description, defaultValue, deprecated);
    }

    public static enum ItemType {
        GROUP,
        PROPERTY;

    }
}

