/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.springframework.boot.configurationprocessor.MetadataCollector;
import org.springframework.boot.configurationprocessor.MetadataStore;
import org.springframework.boot.configurationprocessor.TypeElementMembers;
import org.springframework.boot.configurationprocessor.TypeExcludeFilter;
import org.springframework.boot.configurationprocessor.TypeUtils;
import org.springframework.boot.configurationprocessor.fieldvalues.FieldValuesParser;
import org.springframework.boot.configurationprocessor.fieldvalues.javac.JavaCompilerFieldValuesParser;
import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;
import org.springframework.boot.configurationprocessor.metadata.InvalidConfigurationMetadataException;
import org.springframework.boot.configurationprocessor.metadata.ItemDeprecation;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;

@SupportedAnnotationTypes(value={"*"})
public class ConfigurationMetadataAnnotationProcessor
extends AbstractProcessor {
    static final String CONFIGURATION_PROPERTIES_ANNOTATION = "org.springframework.boot.context.properties.ConfigurationProperties";
    static final String NESTED_CONFIGURATION_PROPERTY_ANNOTATION = "org.springframework.boot.context.properties.NestedConfigurationProperty";
    static final String DEPRECATED_CONFIGURATION_PROPERTY_ANNOTATION = "org.springframework.boot.context.properties.DeprecatedConfigurationProperty";
    static final String LOMBOK_DATA_ANNOTATION = "lombok.Data";
    static final String LOMBOK_GETTER_ANNOTATION = "lombok.Getter";
    static final String LOMBOK_SETTER_ANNOTATION = "lombok.Setter";
    private MetadataStore metadataStore;
    private MetadataCollector metadataCollector;
    private TypeUtils typeUtils;
    private FieldValuesParser fieldValuesParser;
    private TypeExcludeFilter typeExcludeFilter = new TypeExcludeFilter();

    protected String configurationPropertiesAnnotation() {
        return CONFIGURATION_PROPERTIES_ANNOTATION;
    }

    protected String nestedConfigurationPropertyAnnotation() {
        return NESTED_CONFIGURATION_PROPERTY_ANNOTATION;
    }

    protected String deprecatedConfigurationPropertyAnnotation() {
        return DEPRECATED_CONFIGURATION_PROPERTY_ANNOTATION;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.typeUtils = new TypeUtils(env);
        this.metadataStore = new MetadataStore(env);
        this.metadataCollector = new MetadataCollector(env, this.metadataStore.readMetadata());
        try {
            this.fieldValuesParser = new JavaCompilerFieldValuesParser(env);
        }
        catch (Throwable ex) {
            this.fieldValuesParser = FieldValuesParser.NONE;
            this.logWarning("Field value processing of @ConfigurationProperty meta-data is not supported");
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.metadataCollector.processing(roundEnv);
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement annotationType = elementUtils.getTypeElement(this.configurationPropertiesAnnotation());
        if (annotationType != null) {
            for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
                this.processElement(element);
            }
        }
        if (roundEnv.processingOver()) {
            this.writeMetaData();
        }
        return false;
    }

    private void processElement(Element element) {
        try {
            AnnotationMirror annotation = this.getAnnotation(element, this.configurationPropertiesAnnotation());
            if (annotation != null) {
                String prefix = this.getPrefix(annotation);
                if (element instanceof TypeElement) {
                    this.processAnnotatedTypeElement(prefix, (TypeElement)element);
                } else if (element instanceof ExecutableElement) {
                    this.processExecutableElement(prefix, (ExecutableElement)element);
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error processing configuration meta-data on " + element, ex);
        }
    }

    private void processAnnotatedTypeElement(String prefix, TypeElement element) {
        String type = this.typeUtils.getType(element);
        this.metadataCollector.add(ItemMetadata.newGroup(prefix, type, type, null));
        this.processTypeElement(prefix, element);
    }

    private void processExecutableElement(String prefix, ExecutableElement element) {
        Element returns;
        if (element.getModifiers().contains((Object)Modifier.PUBLIC) && TypeKind.VOID != element.getReturnType().getKind() && (returns = this.processingEnv.getTypeUtils().asElement(element.getReturnType())) instanceof TypeElement) {
            this.metadataCollector.add(ItemMetadata.newGroup(prefix, this.typeUtils.getType(returns), this.typeUtils.getType(element.getEnclosingElement()), element.toString()));
            this.processTypeElement(prefix, (TypeElement)returns);
        }
    }

    private void processTypeElement(String prefix, TypeElement element) {
        TypeElementMembers members = new TypeElementMembers(this.processingEnv, element);
        Map<String, Object> fieldValues = this.getFieldValues(element);
        this.processSimpleTypes(prefix, element, members, fieldValues);
        this.processLombokTypes(prefix, element, members, fieldValues);
        this.processNestedTypes(prefix, element, members);
    }

    private Map<String, Object> getFieldValues(TypeElement element) {
        try {
            return this.fieldValuesParser.getFieldValues(element);
        }
        catch (Exception ex) {
            return Collections.emptyMap();
        }
    }

    private void processSimpleTypes(String prefix, TypeElement element, TypeElementMembers members, Map<String, Object> fieldValues) {
        for (Map.Entry<String, ExecutableElement> entry : members.getPublicGetters().entrySet()) {
            String name = entry.getKey();
            ExecutableElement getter = entry.getValue();
            TypeMirror returnType = getter.getReturnType();
            ExecutableElement setter = members.getPublicSetter(name, returnType);
            VariableElement field = members.getFields().get(name);
            Element returnTypeElement = this.processingEnv.getTypeUtils().asElement(returnType);
            boolean isExcluded = this.typeExcludeFilter.isExcluded(returnType);
            boolean isNested = this.isNested(returnTypeElement, field, element);
            boolean isCollection = this.typeUtils.isCollectionOrMap(returnType);
            if (isExcluded || isNested || setter == null && !isCollection) continue;
            String dataType = this.typeUtils.getType(returnType);
            String sourceType = this.typeUtils.getType(element);
            String description = this.typeUtils.getJavaDoc(field);
            Object defaultValue = fieldValues.get(name);
            boolean deprecated = this.isDeprecated(getter) || this.isDeprecated(setter) || this.isDeprecated(element);
            this.metadataCollector.add(ItemMetadata.newProperty(prefix, name, dataType, sourceType, null, description, defaultValue, deprecated ? this.getItemDeprecation(getter) : null));
        }
    }

    private ItemDeprecation getItemDeprecation(ExecutableElement getter) {
        AnnotationMirror annotation = this.getAnnotation(getter, this.deprecatedConfigurationPropertyAnnotation());
        String reason = null;
        String replacement = null;
        if (annotation != null) {
            Map<String, Object> elementValues = this.getAnnotationElementValues(annotation);
            reason = (String)elementValues.get("reason");
            replacement = (String)elementValues.get("replacement");
        }
        return new ItemDeprecation("".equals(reason) ? null : reason, "".equals(replacement) ? null : replacement);
    }

    private void processLombokTypes(String prefix, TypeElement element, TypeElementMembers members, Map<String, Object> fieldValues) {
        for (Map.Entry<String, VariableElement> entry : members.getFields().entrySet()) {
            String name = entry.getKey();
            VariableElement field = entry.getValue();
            if (!this.isLombokField(field, element)) continue;
            TypeMirror returnType = field.asType();
            Element returnTypeElement = this.processingEnv.getTypeUtils().asElement(returnType);
            boolean isExcluded = this.typeExcludeFilter.isExcluded(returnType);
            boolean isNested = this.isNested(returnTypeElement, field, element);
            boolean isCollection = this.typeUtils.isCollectionOrMap(returnType);
            boolean hasSetter = this.hasLombokSetter(field, element);
            if (isExcluded || isNested || !hasSetter && !isCollection) continue;
            String dataType = this.typeUtils.getType(returnType);
            String sourceType = this.typeUtils.getType(element);
            String description = this.typeUtils.getJavaDoc(field);
            Object defaultValue = fieldValues.get(name);
            boolean deprecated = this.isDeprecated(field) || this.isDeprecated(element);
            this.metadataCollector.add(ItemMetadata.newProperty(prefix, name, dataType, sourceType, null, description, defaultValue, deprecated ? new ItemDeprecation() : null));
        }
    }

    private boolean isLombokField(VariableElement field, TypeElement element) {
        return this.hasAnnotation(field, LOMBOK_GETTER_ANNOTATION) || this.hasAnnotation(element, LOMBOK_GETTER_ANNOTATION) || this.hasAnnotation(element, LOMBOK_DATA_ANNOTATION);
    }

    private boolean hasLombokSetter(VariableElement field, TypeElement element) {
        return !field.getModifiers().contains((Object)Modifier.FINAL) && (this.hasAnnotation(field, LOMBOK_SETTER_ANNOTATION) || this.hasAnnotation(element, LOMBOK_SETTER_ANNOTATION) || this.hasAnnotation(element, LOMBOK_DATA_ANNOTATION));
    }

    private void processNestedTypes(String prefix, TypeElement element, TypeElementMembers members) {
        for (Map.Entry<String, ExecutableElement> entry : members.getPublicGetters().entrySet()) {
            String name = entry.getKey();
            ExecutableElement getter = entry.getValue();
            VariableElement field = members.getFields().get(name);
            Element returnType = this.processingEnv.getTypeUtils().asElement(getter.getReturnType());
            AnnotationMirror annotation = this.getAnnotation(getter, this.configurationPropertiesAnnotation());
            boolean isNested = this.isNested(returnType, field, element);
            if (returnType == null || !(returnType instanceof TypeElement) || annotation != null || !isNested) continue;
            String nestedPrefix = ConfigurationMetadata.nestedPrefix(prefix, name);
            this.metadataCollector.add(ItemMetadata.newGroup(nestedPrefix, this.typeUtils.getType(returnType), this.typeUtils.getType(element), getter.toString()));
            this.processTypeElement(nestedPrefix, (TypeElement)returnType);
        }
    }

    private boolean isNested(Element returnType, VariableElement field, TypeElement element) {
        if (this.hasAnnotation(field, this.nestedConfigurationPropertyAnnotation())) {
            return true;
        }
        return this.typeUtils.isEnclosedIn(returnType, element) && returnType.getKind() != ElementKind.ENUM;
    }

    private boolean isDeprecated(Element element) {
        return this.hasAnnotation(element, "java.lang.Deprecated") || this.hasAnnotation(element, this.deprecatedConfigurationPropertyAnnotation());
    }

    private boolean hasAnnotation(Element element, String type) {
        return this.getAnnotation(element, type) != null;
    }

    private AnnotationMirror getAnnotation(Element element, String type) {
        if (element != null) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!type.equals(annotationMirror.getAnnotationType().toString())) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    private String getPrefix(AnnotationMirror annotation) {
        Map<String, Object> elementValues = this.getAnnotationElementValues(annotation);
        Object prefix = elementValues.get("prefix");
        if (prefix != null && !"".equals(prefix)) {
            return (String)prefix;
        }
        Object value = elementValues.get("value");
        if (value != null && !"".equals(value)) {
            return (String)value;
        }
        return null;
    }

    private Map<String, Object> getAnnotationElementValues(AnnotationMirror annotation) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
            values.put(entry.getKey().getSimpleName().toString(), entry.getValue().getValue());
        }
        return values;
    }

    protected ConfigurationMetadata writeMetaData() {
        ConfigurationMetadata metadata = this.metadataCollector.getMetadata();
        if (!(metadata = this.mergeAdditionalMetadata(metadata)).getItems().isEmpty()) {
            try {
                this.metadataStore.writeMetadata(metadata);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to write metadata", ex);
            }
            return metadata;
        }
        return null;
    }

    private ConfigurationMetadata mergeAdditionalMetadata(ConfigurationMetadata metadata) {
        try {
            ConfigurationMetadata merged = new ConfigurationMetadata(metadata);
            merged.merge(this.metadataStore.readAdditionalMetadata());
            return merged;
        }
        catch (FileNotFoundException merged) {
        }
        catch (InvalidConfigurationMetadataException ex) {
            this.log(ex.getKind(), ex.getMessage());
        }
        catch (Exception ex) {
            this.logWarning("Unable to merge additional metadata");
            this.logWarning(this.getStackTrace(ex));
        }
        return metadata;
    }

    private String getStackTrace(Exception ex) {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)writer, true));
        return writer.toString();
    }

    private void logWarning(String msg) {
        this.log(Diagnostic.Kind.WARNING, msg);
    }

    private void log(Diagnostic.Kind kind, String msg) {
        this.processingEnv.getMessager().printMessage(kind, msg);
    }
}

