/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.util.Arrays;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.boot.configurationprocessor.MetadataGenerationEnvironment;
import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;
import org.springframework.boot.configurationprocessor.metadata.ItemDeprecation;
import org.springframework.boot.configurationprocessor.metadata.ItemHint;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;

abstract class PropertyDescriptor {
    private final String name;
    private final TypeMirror type;
    private final TypeElement declaringElement;
    private final ExecutableElement getter;

    PropertyDescriptor(String name, TypeMirror type, TypeElement declaringElement, ExecutableElement getter) {
        this.declaringElement = declaringElement;
        this.name = name;
        this.type = type;
        this.getter = getter;
    }

    String getName() {
        return this.name;
    }

    TypeMirror getType() {
        return this.type;
    }

    protected final TypeElement getDeclaringElement() {
        return this.declaringElement;
    }

    protected final ExecutableElement getGetter() {
        return this.getter;
    }

    final ItemMetadata resolveItemMetadata(String prefix, MetadataGenerationEnvironment environment) {
        if (this.isNested(environment)) {
            return this.resolveItemMetadataGroup(prefix, environment);
        }
        if (this.isProperty(environment)) {
            return this.resolveItemMetadataProperty(prefix, environment);
        }
        return null;
    }

    protected ItemHint resolveItemHint(String prefix, MetadataGenerationEnvironment environment) {
        return null;
    }

    boolean isNested(MetadataGenerationEnvironment environment) {
        Element typeElement = environment.getTypeUtils().asElement(this.getType());
        if (!(typeElement instanceof TypeElement) || typeElement.getKind() == ElementKind.ENUM || environment.getConfigurationPropertiesAnnotation(this.getGetter()) != null) {
            return false;
        }
        if (this.isMarkedAsNested(environment)) {
            return true;
        }
        return !this.isCyclePresent(typeElement, this.getDeclaringElement()) && this.isParentTheSame(environment, typeElement, this.getDeclaringElement());
    }

    protected abstract boolean isMarkedAsNested(MetadataGenerationEnvironment var1);

    private boolean isCyclePresent(Element returnType, Element element) {
        if (!(element.getEnclosingElement() instanceof TypeElement)) {
            return false;
        }
        if (element.getEnclosingElement().equals(returnType)) {
            return true;
        }
        return this.isCyclePresent(returnType, element.getEnclosingElement());
    }

    private boolean isParentTheSame(MetadataGenerationEnvironment environment, Element returnType, TypeElement element) {
        if (returnType == null || element == null) {
            return false;
        }
        returnType = this.getTopLevelType(returnType);
        Element candidate = element;
        while (candidate instanceof TypeElement) {
            if (returnType.equals(this.getTopLevelType(candidate))) {
                return true;
            }
            candidate = environment.getTypeUtils().asElement(candidate.getSuperclass());
        }
        return false;
    }

    private Element getTopLevelType(Element element) {
        if (!(element.getEnclosingElement() instanceof TypeElement)) {
            return element;
        }
        return this.getTopLevelType(element.getEnclosingElement());
    }

    private ItemMetadata resolveItemMetadataGroup(String prefix, MetadataGenerationEnvironment environment) {
        Element propertyElement = environment.getTypeUtils().asElement(this.getType());
        String nestedPrefix = ConfigurationMetadata.nestedPrefix(prefix, this.getName());
        String dataType = environment.getTypeUtils().getQualifiedName(propertyElement);
        String ownerType = environment.getTypeUtils().getQualifiedName(this.getDeclaringElement());
        String sourceMethod = this.getGetter() != null ? this.getGetter().toString() : null;
        return ItemMetadata.newGroup(nestedPrefix, dataType, ownerType, sourceMethod);
    }

    private ItemMetadata resolveItemMetadataProperty(String prefix, MetadataGenerationEnvironment environment) {
        String dataType = this.resolveType(environment);
        String ownerType = environment.getTypeUtils().getQualifiedName(this.getDeclaringElement());
        String description = this.resolveDescription(environment);
        Object defaultValue = this.resolveDefaultValue(environment);
        ItemDeprecation deprecation = this.resolveItemDeprecation(environment);
        return ItemMetadata.newProperty(prefix, this.getName(), dataType, ownerType, null, description, defaultValue, deprecation);
    }

    protected final ItemDeprecation resolveItemDeprecation(MetadataGenerationEnvironment environment, Element ... elements) {
        boolean deprecated = Arrays.stream(elements).anyMatch(environment::isDeprecated);
        return deprecated ? environment.resolveItemDeprecation(this.getGetter()) : null;
    }

    private String resolveType(MetadataGenerationEnvironment environment) {
        return environment.getTypeUtils().getType(this.getDeclaringElement(), this.getType());
    }

    protected abstract String resolveDescription(MetadataGenerationEnvironment var1);

    protected abstract Object resolveDefaultValue(MetadataGenerationEnvironment var1);

    protected abstract ItemDeprecation resolveItemDeprecation(MetadataGenerationEnvironment var1);

    abstract boolean isProperty(MetadataGenerationEnvironment var1);
}

