/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.util.Assert;

public interface DataRedisConnectionDetails
extends ConnectionDetails {
    default public @Nullable String getUsername() {
        return null;
    }

    default public @Nullable String getPassword() {
        return null;
    }

    default public @Nullable SslBundle getSslBundle() {
        return null;
    }

    default public @Nullable Standalone getStandalone() {
        return null;
    }

    default public @Nullable Sentinel getSentinel() {
        return null;
    }

    default public @Nullable Cluster getCluster() {
        return null;
    }

    default public @Nullable MasterReplica getMasterReplica() {
        return null;
    }

    public record Node(String host, int port) {
    }

    public static interface MasterReplica {
        public List<Node> getNodes();
    }

    public static interface Cluster {
        public List<Node> getNodes();
    }

    public static interface Sentinel {
        public int getDatabase();

        public String getMaster();

        public List<Node> getNodes();

        public @Nullable String getUsername();

        public @Nullable String getPassword();
    }

    public static interface Standalone {
        public String getHost();

        public int getPort();

        default public int getDatabase() {
            return 0;
        }

        public static Standalone of(String host, int port) {
            return Standalone.of(host, port, 0);
        }

        public static Standalone of(final String host, final int port, final int database) {
            Assert.hasLength((String)host, (String)"'host' must not be empty");
            return new Standalone(){

                @Override
                public String getHost() {
                    return host;
                }

                @Override
                public int getPort() {
                    return port;
                }

                @Override
                public int getDatabase() {
                    return database;
                }
            };
        }
    }
}

