/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import java.util.Collection;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.devtools.autoconfigure.DevToolsProperties;
import org.springframework.boot.devtools.autoconfigure.RemoteDevToolsProperties;
import org.springframework.boot.devtools.remote.server.AccessManager;
import org.springframework.boot.devtools.remote.server.Dispatcher;
import org.springframework.boot.devtools.remote.server.DispatcherFilter;
import org.springframework.boot.devtools.remote.server.HandlerMapper;
import org.springframework.boot.devtools.remote.server.HttpHeaderAccessManager;
import org.springframework.boot.devtools.remote.server.HttpStatusHandler;
import org.springframework.boot.devtools.remote.server.UrlHandlerMapper;
import org.springframework.boot.devtools.restart.server.DefaultSourceFolderUrlFilter;
import org.springframework.boot.devtools.restart.server.HttpRestartServer;
import org.springframework.boot.devtools.restart.server.HttpRestartServerHandler;
import org.springframework.boot.devtools.restart.server.SourceFolderUrlFilter;
import org.springframework.boot.devtools.tunnel.server.HttpTunnelServer;
import org.springframework.boot.devtools.tunnel.server.HttpTunnelServerHandler;
import org.springframework.boot.devtools.tunnel.server.RemoteDebugPortProvider;
import org.springframework.boot.devtools.tunnel.server.SocketTargetServerConnection;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.ServerHttpRequest;

@Configuration
@ConditionalOnProperty(prefix="spring.devtools.remote", name={"secret"})
@ConditionalOnClass(value={Filter.class, ServerHttpRequest.class})
@EnableConfigurationProperties(value={DevToolsProperties.class})
public class RemoteDevToolsAutoConfiguration {
    private static final Log logger = LogFactory.getLog(RemoteDevToolsAutoConfiguration.class);
    @Autowired
    private DevToolsProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public AccessManager remoteDevToolsAccessManager() {
        RemoteDevToolsProperties remoteProperties = this.properties.getRemote();
        return new HttpHeaderAccessManager(remoteProperties.getSecretHeaderName(), remoteProperties.getSecret());
    }

    @Bean
    public HandlerMapper remoteDevToolsHealthCheckHandlerMapper() {
        HttpStatusHandler handler = new HttpStatusHandler();
        return new UrlHandlerMapper(this.properties.getRemote().getContextPath(), handler);
    }

    @Bean
    @ConditionalOnMissingBean
    public DispatcherFilter remoteDevToolsDispatcherFilter(AccessManager accessManager, Collection<HandlerMapper> mappers) {
        Dispatcher dispatcher = new Dispatcher(accessManager, mappers);
        return new DispatcherFilter(dispatcher);
    }

    @ConditionalOnProperty(prefix="spring.devtools.remote.debug", name={"enabled"}, matchIfMissing=true)
    static class RemoteDebugTunnelConfiguration {
        @Autowired
        private DevToolsProperties properties;

        RemoteDebugTunnelConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"remoteDebugHanderMapper"})
        public UrlHandlerMapper remoteDebugHanderMapper(@Qualifier(value="remoteDebugHttpTunnelServer") HttpTunnelServer server) {
            String url = this.properties.getRemote().getContextPath() + "/debug";
            logger.warn((Object)("Listening for remote debug traffic on " + url));
            HttpTunnelServerHandler handler = new HttpTunnelServerHandler(server);
            return new UrlHandlerMapper(url, handler);
        }

        @Bean
        @ConditionalOnMissingBean(name={"remoteDebugHttpTunnelServer"})
        public HttpTunnelServer remoteDebugHttpTunnelServer() {
            return new HttpTunnelServer(new SocketTargetServerConnection(new RemoteDebugPortProvider()));
        }
    }

    @ConditionalOnProperty(prefix="spring.devtools.remote.restart", name={"enabled"}, matchIfMissing=true)
    static class RemoteRestartConfiguration {
        @Autowired
        private DevToolsProperties properties;

        RemoteRestartConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public SourceFolderUrlFilter remoteRestartSourceFolderUrlFilter() {
            return new DefaultSourceFolderUrlFilter();
        }

        @Bean
        @ConditionalOnMissingBean
        public HttpRestartServer remoteRestartHttpRestartServer(SourceFolderUrlFilter sourceFolderUrlFilter) {
            return new HttpRestartServer(sourceFolderUrlFilter);
        }

        @Bean
        @ConditionalOnMissingBean(name={"remoteRestartHanderMapper"})
        public UrlHandlerMapper remoteRestartHanderMapper(HttpRestartServer server) {
            String url = this.properties.getRemote().getContextPath() + "/restart";
            logger.warn((Object)("Listening for remote restart updates on " + url));
            HttpRestartServerHandler handler = new HttpRestartServerHandler(server);
            return new UrlHandlerMapper(url, handler);
        }
    }
}

