/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

class SilentExitExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler delegate;

    public SilentExitExceptionHandler(Thread.UncaughtExceptionHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        if (exception instanceof SilentExitException) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.uncaughtException(thread, exception);
        }
    }

    public static void setup(Thread thread) {
        Thread.UncaughtExceptionHandler handler = thread.getUncaughtExceptionHandler();
        if (!(handler instanceof SilentExitExceptionHandler)) {
            handler = new SilentExitExceptionHandler(handler);
            thread.setUncaughtExceptionHandler(handler);
        }
    }

    public static void exitCurrentThread() {
        throw new SilentExitException();
    }

    private static class SilentExitException
    extends RuntimeException {
        private SilentExitException() {
        }
    }
}

