/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class DevToolsEnablementDeducer {
    private static final Set<String> SKIPPED_STACK_ELEMENTS;

    private DevToolsEnablementDeducer() {
    }

    public static boolean shouldEnable(Thread thread) {
        for (StackTraceElement element : thread.getStackTrace()) {
            if (!DevToolsEnablementDeducer.isSkippedStackElement(element)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSkippedStackElement(StackTraceElement element) {
        for (String skipped : SKIPPED_STACK_ELEMENTS) {
            if (!element.getClassName().startsWith(skipped)) continue;
            return true;
        }
        return false;
    }

    static {
        LinkedHashSet<String> skipped = new LinkedHashSet<String>();
        skipped.add("org.junit.runners.");
        skipped.add("org.junit.platform.");
        skipped.add("org.springframework.boot.test.");
        skipped.add("cucumber.runtime.");
        SKIPPED_STACK_ELEMENTS = Collections.unmodifiableSet(skipped);
    }
}

