/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.gradle.agent.AgentPluginFeatures;
import org.springframework.boot.gradle.dependencymanagement.DependencyManagementPluginFeatures;
import org.springframework.boot.gradle.repackage.RepackagePluginFeatures;
import org.springframework.boot.gradle.run.RunPluginFeatures;

public class SpringBootPlugin
implements Plugin<Project> {
    private static final Logger logger = LoggerFactory.getLogger(SpringBootPlugin.class);

    public void apply(Project project) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"2.9")) < 0) {
            logger.warn("Spring Boot plugin's support for Gradle " + GradleVersion.current().getVersion() + " is deprecated. Please upgrade to Gradle 2.9 or later.");
        }
        project.getExtensions().create("springBoot", SpringBootPluginExtension.class, new Object[]{project});
        project.getPlugins().apply(JavaPlugin.class);
        new AgentPluginFeatures().apply(project);
        new RepackagePluginFeatures().apply(project);
        new RunPluginFeatures().apply(project);
        new DependencyManagementPluginFeatures().apply(project);
        project.getTasks().withType(JavaCompile.class).all((Action)new SetUtf8EncodingAction());
    }

    private static class SetUtf8EncodingAction
    implements Action<JavaCompile> {
        private SetUtf8EncodingAction() {
        }

        public void execute(final JavaCompile compile) {
            compile.doFirst((Action)new Action<Task>(){

                public void execute(Task t) {
                    if (compile.getOptions().getEncoding() == null) {
                        compile.getOptions().setEncoding("UTF-8");
                    }
                }
            });
        }
    }
}

