/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.util.Collections;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.compile.JavaCompile;
import org.springframework.boot.gradle.plugin.MainClassConvention;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.SinglePublishedArtifact;
import org.springframework.boot.gradle.plugin.SpringBootSoftwareComponent;
import org.springframework.boot.gradle.tasks.bundling.BootJar;
import org.springframework.boot.gradle.tasks.run.BootRun;

final class JavaPluginAction
implements PluginApplicationAction {
    private final SinglePublishedArtifact singlePublishedArtifact;

    JavaPluginAction(SinglePublishedArtifact singlePublishedArtifact) {
        this.singlePublishedArtifact = singlePublishedArtifact;
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return JavaPlugin.class;
    }

    public void execute(Project project) {
        this.disableJarTask(project);
        this.configureBuildTask(project);
        BootJar bootJar = this.configureBootJarTask(project);
        this.configureArtifactPublication(project, bootJar);
        this.configureBootRunTask(project);
        this.configureUtf8Encoding(project);
    }

    private void disableJarTask(Project project) {
        project.getTasks().getByName("jar").setEnabled(false);
    }

    private void configureBuildTask(Project project) {
        project.getTasks().getByName("assemble").dependsOn(new Object[]{this.singlePublishedArtifact});
    }

    private BootJar configureBootJarTask(Project project) {
        BootJar bootJar = (BootJar)project.getTasks().create("bootJar", BootJar.class);
        bootJar.setDescription("Assembles an executable jar archive containing the main classes and their dependencies.");
        bootJar.setGroup("build");
        bootJar.classpath(() -> {
            JavaPluginConvention convention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSet mainSourceSet = (SourceSet)convention.getSourceSets().getByName("main");
            return mainSourceSet.getRuntimeClasspath();
        });
        bootJar.conventionMapping("mainClass", new MainClassConvention(project, bootJar::getClasspath));
        return bootJar;
    }

    private void configureArtifactPublication(Project project, BootJar bootJar) {
        ArchivePublishArtifact artifact = new ArchivePublishArtifact((AbstractArchiveTask)bootJar);
        this.singlePublishedArtifact.addCandidate((PublishArtifact)artifact);
        project.getComponents().add((Object)new SpringBootSoftwareComponent((PublishArtifact)artifact, "bootJava"));
    }

    private void configureBootRunTask(Project project) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        BootRun run = (BootRun)project.getTasks().create("bootRun", BootRun.class);
        run.setDescription("Runs this project as a Spring Boot application.");
        run.setGroup("application");
        run.classpath(new Object[]{((SourceSet)javaConvention.getSourceSets().findByName("main")).getRuntimeClasspath()});
        run.getConventionMapping().map("jvmArgs", () -> {
            if (project.hasProperty("applicationDefaultJvmArgs")) {
                return project.property("applicationDefaultJvmArgs");
            }
            return Collections.emptyList();
        });
        run.conventionMapping("main", new MainClassConvention(project, () -> ((BootRun)run).getClasspath()));
    }

    private void configureUtf8Encoding(Project project) {
        project.afterEvaluate(evaluated -> evaluated.getTasks().withType(JavaCompile.class, compile -> {
            if (compile.getOptions().getEncoding() == null) {
                compile.getOptions().setEncoding("UTF-8");
            }
        }));
    }
}

