/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.dsl;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.jvm.tasks.Jar;
import org.springframework.boot.gradle.tasks.buildinfo.BuildInfo;
import org.springframework.boot.gradle.tasks.buildinfo.BuildInfoProperties;

public class SpringBootExtension {
    private final Project project;

    public SpringBootExtension(Project project) {
        this.project = project;
    }

    public void buildInfo() {
        this.buildInfo(null);
    }

    public void buildInfo(Action<BuildInfo> configurer) {
        BuildInfo bootBuildInfo = (BuildInfo)this.project.getTasks().create("bootBuildInfo", BuildInfo.class);
        bootBuildInfo.setGroup("build");
        bootBuildInfo.setDescription("Generates a META-INF/build-info.properties file.");
        this.project.getPlugins().withType(JavaPlugin.class, plugin -> {
            this.project.getTasks().getByName("classes").dependsOn(new Object[]{bootBuildInfo});
            this.project.afterEvaluate(evaluated -> {
                BuildInfoProperties properties = bootBuildInfo.getProperties();
                if (properties.getArtifact() == null) {
                    properties.setArtifact(this.determineArtifactBaseName());
                }
            });
            bootBuildInfo.setDestinationDir((Provider<File>)this.project.provider(() -> new File(this.determineMainSourceSetResourcesOutputDir(), "META-INF")));
        });
        if (configurer != null) {
            configurer.execute((Object)bootBuildInfo);
        }
    }

    private File determineMainSourceSetResourcesOutputDir() {
        return ((SourceSet)((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getOutput().getResourcesDir();
    }

    private String determineArtifactBaseName() {
        Jar artifactTask = this.findArtifactTask();
        return artifactTask == null ? null : artifactTask.getBaseName();
    }

    private Jar findArtifactTask() {
        Jar artifactTask = (Jar)this.project.getTasks().findByName("bootWar");
        if (artifactTask != null) {
            return artifactTask;
        }
        return (Jar)this.project.getTasks().findByName("bootJar");
    }
}

