/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import io.spring.gradle.dependencymanagement.DependencyManagementPlugin;
import io.spring.gradle.dependencymanagement.dsl.DependencyManagementExtension;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;

final class DependencyManagementPluginAction
implements PluginApplicationAction {
    private static final String SPRING_BOOT_VERSION = DependencyManagementPluginAction.determineSpringBootVersion();
    private static final String SPRING_BOOT_BOM = "org.springframework.boot:spring-boot-dependencies:" + SPRING_BOOT_VERSION;

    DependencyManagementPluginAction() {
    }

    public void execute(Project project) {
        ((DependencyManagementExtension)project.getExtensions().findByType(DependencyManagementExtension.class)).imports(importsHandler -> importsHandler.mavenBom(SPRING_BOOT_BOM));
    }

    public Class<? extends Plugin<Project>> getPluginClass() {
        return DependencyManagementPlugin.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String determineSpringBootVersion() {
        String implementationVersion = DependencyManagementPluginAction.class.getPackage().getImplementationVersion();
        if (implementationVersion != null) {
            return implementationVersion;
        }
        URL codeSourceLocation = DependencyManagementPluginAction.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            URLConnection connection = codeSourceLocation.openConnection();
            if (connection instanceof JarURLConnection) {
                return DependencyManagementPluginAction.getImplementationVersion(((JarURLConnection)connection).getJarFile());
            }
            try (JarFile jarFile = new JarFile(new File(codeSourceLocation.toURI()));){
                String string = DependencyManagementPluginAction.getImplementationVersion(jarFile);
                return string;
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String getImplementationVersion(JarFile jarFile) throws IOException {
        return jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }
}

