/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.compile.JavaCompile;
import org.springframework.boot.gradle.plugin.MainClassConvention;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.SinglePublishedArtifact;
import org.springframework.boot.gradle.tasks.bundling.BootJar;
import org.springframework.boot.gradle.tasks.run.BootRun;

final class JavaPluginAction
implements PluginApplicationAction {
    private static final String PARAMETERS_COMPILER_ARG = "-parameters";
    private final SinglePublishedArtifact singlePublishedArtifact;

    JavaPluginAction(SinglePublishedArtifact singlePublishedArtifact) {
        this.singlePublishedArtifact = singlePublishedArtifact;
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return JavaPlugin.class;
    }

    public void execute(Project project) {
        this.disableJarTask(project);
        this.configureBuildTask(project);
        BootJar bootJar = this.configureBootJarTask(project);
        this.configureArtifactPublication(project, bootJar);
        this.configureBootRunTask(project);
        this.configureUtf8Encoding(project);
        this.configureParametersCompilerArg(project);
    }

    private void disableJarTask(Project project) {
        project.getTasks().getByName("jar").setEnabled(false);
    }

    private void configureBuildTask(Project project) {
        project.getTasks().getByName("assemble").dependsOn(new Object[]{this.singlePublishedArtifact});
    }

    private BootJar configureBootJarTask(Project project) {
        BootJar bootJar = (BootJar)project.getTasks().create("bootJar", BootJar.class);
        bootJar.setDescription("Assembles an executable jar archive containing the main classes and their dependencies.");
        bootJar.setGroup("build");
        bootJar.classpath(() -> {
            JavaPluginConvention convention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSet mainSourceSet = (SourceSet)convention.getSourceSets().getByName("main");
            return mainSourceSet.getRuntimeClasspath();
        });
        bootJar.conventionMapping("mainClass", new MainClassConvention(project, bootJar::getClasspath));
        return bootJar;
    }

    private void configureArtifactPublication(Project project, BootJar bootJar) {
        ArchivePublishArtifact artifact = new ArchivePublishArtifact((AbstractArchiveTask)bootJar);
        this.singlePublishedArtifact.addCandidate((PublishArtifact)artifact);
    }

    private void configureBootRunTask(Project project) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        BootRun run = (BootRun)project.getTasks().create("bootRun", BootRun.class);
        run.setDescription("Runs this project as a Spring Boot application.");
        run.setGroup("application");
        run.classpath(((SourceSet)javaConvention.getSourceSets().findByName("main")).getRuntimeClasspath());
        run.setJvmArgs((Provider<List<String>>)project.provider(() -> {
            if (project.hasProperty("applicationDefaultJvmArgs")) {
                return (List)project.property("applicationDefaultJvmArgs");
            }
            return Collections.emptyList();
        }));
        run.setMain((Provider<String>)project.provider((Callable)new MainClassConvention(project, run::getClasspath)));
    }

    private void configureUtf8Encoding(Project project) {
        project.afterEvaluate(evaluated -> evaluated.getTasks().withType(JavaCompile.class, compile -> {
            if (compile.getOptions().getEncoding() == null) {
                compile.getOptions().setEncoding("UTF-8");
            }
        }));
    }

    private void configureParametersCompilerArg(Project project) {
        project.getTasks().withType(JavaCompile.class, compile -> {
            List compilerArgs = compile.getOptions().getCompilerArgs();
            if (!compilerArgs.contains(PARAMETERS_COMPILER_ARG)) {
                compilerArgs.add(PARAMETERS_COMPILER_ARG);
            }
        });
    }
}

