/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.util.PatternSet;
import org.springframework.boot.gradle.tasks.bundling.BootZipCopyAction;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;

class BootArchiveSupport {
    private static final Set<String> DEFAULT_LAUNCHER_CLASSES;
    private final PatternSet requiresUnpack = new PatternSet();
    private final Function<FileCopyDetails, ZipCompression> compressionResolver;
    private final PatternSet exclusions = new PatternSet();
    private final String loaderMainClass;
    private LaunchScriptConfiguration launchScript;
    private boolean excludeDevtools = true;

    BootArchiveSupport(String loaderMainClass, Function<FileCopyDetails, ZipCompression> compressionResolver) {
        this.loaderMainClass = loaderMainClass;
        this.compressionResolver = compressionResolver;
        this.requiresUnpack.include(Specs.satisfyNone());
        this.configureExclusions();
    }

    void configureManifest(Jar jar, String mainClass) {
        Attributes attributes = jar.getManifest().getAttributes();
        attributes.putIfAbsent((Object)"Main-Class", (Object)this.loaderMainClass);
        attributes.putIfAbsent((Object)"Start-Class", (Object)mainClass);
    }

    CopyAction createCopyAction(Jar jar) {
        BootZipCopyAction copyAction = new BootZipCopyAction(jar.getArchivePath(), jar.isPreserveFileTimestamps(), this.isUsingDefaultLoader(jar), (Spec<FileTreeElement>)this.requiresUnpack.getAsSpec(), (Spec<FileTreeElement>)this.exclusions.getAsExcludeSpec(), this.launchScript, this.compressionResolver, jar.getMetadataCharset());
        if (!jar.isReproducibleFileOrder()) {
            return copyAction;
        }
        return new ReproducibleOrderingCopyAction(copyAction);
    }

    private boolean isUsingDefaultLoader(Jar jar) {
        return DEFAULT_LAUNCHER_CLASSES.contains(jar.getManifest().getAttributes().get((Object)"Main-Class"));
    }

    LaunchScriptConfiguration getLaunchScript() {
        return this.launchScript;
    }

    void setLaunchScript(LaunchScriptConfiguration launchScript) {
        this.launchScript = launchScript;
    }

    void requiresUnpack(String ... patterns) {
        this.requiresUnpack.include(patterns);
    }

    void requiresUnpack(Spec<FileTreeElement> spec) {
        this.requiresUnpack.include(spec);
    }

    boolean isExcludeDevtools() {
        return this.excludeDevtools;
    }

    void setExcludeDevtools(boolean excludeDevtools) {
        this.excludeDevtools = excludeDevtools;
        this.configureExclusions();
    }

    private void configureExclusions() {
        HashSet<String> excludes = new HashSet<String>();
        if (this.excludeDevtools) {
            excludes.add("**/spring-boot-devtools-*.jar");
        }
        this.exclusions.setExcludes(excludes);
    }

    static {
        HashSet<String> defaultLauncherClasses = new HashSet<String>();
        defaultLauncherClasses.add("org.springframework.boot.loader.JarLauncher");
        defaultLauncherClasses.add("org.springframework.boot.loader.PropertiesLauncher");
        defaultLauncherClasses.add("org.springframework.boot.loader.WarLauncher");
        DEFAULT_LAUNCHER_CLASSES = Collections.unmodifiableSet(defaultLauncherClasses);
    }

    private static final class ReproducibleOrderingCopyAction
    implements CopyAction {
        private final CopyAction delegate;

        private ReproducibleOrderingCopyAction(CopyAction delegate) {
            this.delegate = delegate;
        }

        public WorkResult execute(CopyActionProcessingStream stream) {
            return this.delegate.execute(action -> {
                TreeMap detailsByPath = new TreeMap();
                stream.process(details -> detailsByPath.put(details.getRelativePath(), details));
                detailsByPath.values().stream().forEach(arg_0 -> ((CopyActionProcessingStreamAction)action).processFile(arg_0));
            });
        }
    }
}

