/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.buildinfo;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.springframework.boot.gradle.tasks.buildinfo.BuildInfoProperties;
import org.springframework.boot.loader.tools.BuildPropertiesWriter;

public class BuildInfo
extends ConventionTask {
    private final BuildInfoProperties properties = new BuildInfoProperties(this.getProject());
    private File destinationDir;

    @TaskAction
    public void generateBuildProperties() {
        try {
            new BuildPropertiesWriter(new File(this.getDestinationDir(), "build-info.properties")).writeBuildProperties(new BuildPropertiesWriter.ProjectDetails(this.properties.getGroup(), this.properties.getArtifact() != null ? this.properties.getArtifact() : "unspecified", this.properties.getVersion(), this.properties.getName(), this.properties.getTime(), this.coerceToStringValues(this.properties.getAdditional())));
        }
        catch (IOException ex) {
            throw new TaskExecutionException((Task)this, (Throwable)ex);
        }
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir != null ? this.destinationDir : this.getProject().getBuildDir();
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    @Input
    public BuildInfoProperties getProperties() {
        return this.properties;
    }

    public void properties(Action<BuildInfoProperties> action) {
        action.execute((Object)this.properties);
    }

    private Map<String, String> coerceToStringValues(Map<String, Object> input) {
        HashMap<String, String> output = new HashMap<String, String>();
        input.forEach((key, value) -> output.put((String)key, value.toString()));
        return output;
    }
}

