/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.springframework.boot.loader.tools.JarWriter;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.Layouts;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.boot.loader.tools.MainClassFinder;

public class Repackager {
    private static final String MAIN_CLASS_ATTRIBUTE = "Main-Class";
    private static final String START_CLASS_ATTRIBUTE = "Start-Class";
    private static final String BOOT_VERSION_ATTRIBUTE = "Spring-Boot-Version";
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private String mainClass;
    private boolean backupSource = true;
    private final File source;
    private Layout layout;

    public Repackager(File source) {
        if (source == null || !source.exists() || !source.isFile()) {
            throw new IllegalArgumentException("Source must refer to an existing file");
        }
        this.source = source.getAbsoluteFile();
        this.layout = Layouts.forFile(source);
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setBackupSource(boolean backupSource) {
        this.backupSource = backupSource;
    }

    public void setLayout(Layout layout) {
        if (layout == null) {
            throw new IllegalArgumentException("Layout must not be null");
        }
        this.layout = layout;
    }

    public void repackage(Libraries libraries) throws IOException {
        this.repackage(this.source, libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repackage(File destination, Libraries libraries) throws IOException {
        if (destination == null || destination.isDirectory()) {
            throw new IllegalArgumentException("Invalid destination");
        }
        if (libraries == null) {
            throw new IllegalArgumentException("Libraries must not be null");
        }
        destination = destination.getAbsoluteFile();
        File workingSource = this.source;
        if (this.source.equals(destination)) {
            workingSource = new File(this.source.getParentFile(), this.source.getName() + ".original");
            workingSource.delete();
            this.renameFile(this.source, workingSource);
        }
        destination.delete();
        try {
            JarFile jarFileSource = new JarFile(workingSource);
            try {
                this.repackage(jarFileSource, destination, libraries);
            }
            finally {
                jarFileSource.close();
            }
        }
        finally {
            if (!this.backupSource && !this.source.equals(workingSource)) {
                this.deleteFile(workingSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repackage(JarFile sourceJar, File destination, Libraries libraries) throws IOException {
        final JarWriter writer = new JarWriter(destination);
        try {
            writer.writeManifest(this.buildManifest(sourceJar));
            writer.writeEntries(sourceJar);
            libraries.doWithLibraries(new LibraryCallback(){

                @Override
                public void library(File file, LibraryScope scope) throws IOException {
                    String destination;
                    if (Repackager.this.isZip(file) && (destination = Repackager.this.layout.getLibraryDestination(file.getName(), scope)) != null) {
                        writer.writeNestedLibrary(destination, file);
                    }
                }
            });
            if (!(this.layout instanceof Layouts.None)) {
                writer.writeLoaderClasses();
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZip(File file) {
        boolean bl;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            bl = this.isZip(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        fileInputStream.close();
        return bl;
    }

    private boolean isZip(InputStream inputStream) throws IOException {
        for (int i = 0; i < ZIP_FILE_HEADER.length; ++i) {
            if (inputStream.read() == ZIP_FILE_HEADER[i]) continue;
            return false;
        }
        return true;
    }

    private Manifest buildManifest(JarFile source) throws IOException {
        String launcherClassName;
        Manifest manifest = source.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
            manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        }
        manifest = new Manifest(manifest);
        String startClass = this.mainClass;
        if (startClass == null) {
            startClass = manifest.getMainAttributes().getValue(MAIN_CLASS_ATTRIBUTE);
        }
        if (startClass == null) {
            startClass = this.findMainMethod(source);
        }
        if ((launcherClassName = this.layout.getLauncherClassName()) != null) {
            manifest.getMainAttributes().putValue(MAIN_CLASS_ATTRIBUTE, launcherClassName);
            if (startClass == null) {
                throw new IllegalStateException("Unable to find main class");
            }
            manifest.getMainAttributes().putValue(START_CLASS_ATTRIBUTE, startClass);
        } else if (startClass != null) {
            manifest.getMainAttributes().putValue(MAIN_CLASS_ATTRIBUTE, startClass);
        }
        String bootVersion = this.getClass().getPackage().getImplementationVersion();
        manifest.getMainAttributes().putValue(BOOT_VERSION_ATTRIBUTE, bootVersion);
        return manifest;
    }

    protected String findMainMethod(JarFile source) throws IOException {
        return MainClassFinder.findSingleMainClass(source, this.layout.getClassesLocation());
    }

    private void renameFile(File file, File dest) {
        if (!file.renameTo(dest)) {
            throw new IllegalStateException("Unable to rename '" + file + "' to '" + dest + "'");
        }
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            throw new IllegalStateException("Unable to delete '" + file + "'");
        }
    }
}

