/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.springframework.boot.loader.tools.FileUtils;
import org.springframework.boot.loader.tools.LaunchScript;
import org.springframework.boot.loader.tools.Library;

public class JarWriter {
    private static final String NESTED_LOADER_JAR = "META-INF/loader/spring-boot-loader.jar";
    private static final int BUFFER_SIZE = 32768;
    private final JarOutputStream jarOutput;
    private final Set<String> writtenEntries = new HashSet<String>();

    public JarWriter(File file) throws FileNotFoundException, IOException {
        this(file, null);
    }

    public JarWriter(File file, LaunchScript launchScript) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (launchScript != null) {
            fileOutputStream.write(launchScript.toByteArray());
            this.setExecutableFilePermission(file);
        }
        this.jarOutput = new JarOutputStream(fileOutputStream);
    }

    private void setExecutableFilePermission(File file) {
        try {
            Path path = file.toPath();
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(path, permissions);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void writeManifest(final Manifest manifest) throws IOException {
        JarEntry entry = new JarEntry("META-INF/MANIFEST.MF");
        this.writeEntry(entry, new EntryWriter(){

            @Override
            public void write(OutputStream outputStream) throws IOException {
                manifest.write(outputStream);
            }
        });
    }

    public void writeEntries(JarFile jarFile) throws IOException {
        this.writeEntries(jarFile, new IdentityEntryTransformer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeEntries(JarFile jarFile, EntryTransformer entryTransformer) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            ZipHeaderPeekInputStream inputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream(entry));
            try {
                if (inputStream.hasZipHeader() && entry.getMethod() != 0) {
                    new CrcAndSize(inputStream).setupStoredEntry(entry);
                    inputStream.close();
                    inputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream(entry));
                }
                InputStreamEntryWriter entryWriter = new InputStreamEntryWriter(inputStream, true);
                this.writeEntry(entryTransformer.transform(entry), entryWriter);
            }
            finally {
                inputStream.close();
            }
        }
    }

    public void writeEntry(String entryName, InputStream inputStream) throws IOException {
        JarEntry entry = new JarEntry(entryName);
        this.writeEntry(entry, new InputStreamEntryWriter(inputStream, true));
    }

    public void writeNestedLibrary(String destination, Library library) throws IOException {
        File file = library.getFile();
        JarEntry entry = new JarEntry(destination + library.getName());
        entry.setTime(this.getNestedLibraryTime(file));
        if (library.isUnpackRequired()) {
            entry.setComment("UNPACK:" + FileUtils.sha1Hash(file));
        }
        new CrcAndSize(file).setupStoredEntry(entry);
        this.writeEntry(entry, new InputStreamEntryWriter(new FileInputStream(file), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getNestedLibraryTime(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            try {
                JarEntry entry;
                Enumeration<JarEntry> entries = jarFile.entries();
                do {
                    if (!entries.hasMoreElements()) return file.lastModified();
                } while ((entry = entries.nextElement()).isDirectory());
                long l = entry.getTime();
                return l;
            }
            finally {
                jarFile.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file.lastModified();
    }

    public void writeLoaderClasses() throws IOException {
        JarEntry entry;
        URL loaderJar = this.getClass().getClassLoader().getResource(NESTED_LOADER_JAR);
        JarInputStream inputStream = new JarInputStream(new BufferedInputStream(loaderJar.openStream()));
        while ((entry = inputStream.getNextJarEntry()) != null) {
            if (!entry.getName().endsWith(".class")) continue;
            this.writeEntry(entry, new InputStreamEntryWriter(inputStream, false));
        }
        inputStream.close();
    }

    public void close() throws IOException {
        this.jarOutput.close();
    }

    private void writeEntry(JarEntry entry, EntryWriter entryWriter) throws IOException {
        String parent = entry.getName();
        if (parent.endsWith("/")) {
            parent = parent.substring(0, parent.length() - 1);
        }
        if (parent.lastIndexOf("/") != -1 && (parent = parent.substring(0, parent.lastIndexOf("/") + 1)).length() > 0) {
            this.writeEntry(new JarEntry(parent), null);
        }
        if (this.writtenEntries.add(entry.getName())) {
            this.jarOutput.putNextEntry(entry);
            if (entryWriter != null) {
                entryWriter.write(this.jarOutput);
            }
            this.jarOutput.closeEntry();
        }
    }

    private static final class IdentityEntryTransformer
    implements EntryTransformer {
        private IdentityEntryTransformer() {
        }

        @Override
        public JarEntry transform(JarEntry jarEntry) {
            return jarEntry;
        }
    }

    static interface EntryTransformer {
        public JarEntry transform(JarEntry var1);
    }

    private static class CrcAndSize {
        private final CRC32 crc = new CRC32();
        private long size;

        CrcAndSize(File file) throws IOException {
            FileInputStream inputStream = new FileInputStream(file);
            try {
                this.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }

        CrcAndSize(InputStream inputStream) throws IOException {
            this.load(inputStream);
        }

        private void load(InputStream inputStream) throws IOException {
            byte[] buffer = new byte[32768];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.crc.update(buffer, 0, bytesRead);
                this.size += (long)bytesRead;
            }
        }

        public void setupStoredEntry(JarEntry entry) {
            entry.setSize(this.size);
            entry.setCompressedSize(this.size);
            entry.setCrc(this.crc.getValue());
            entry.setMethod(0);
        }
    }

    private static class ZipHeaderPeekInputStream
    extends FilterInputStream {
        private static final byte[] ZIP_HEADER = new byte[]{80, 75, 3, 4};
        private final byte[] header = new byte[4];
        private ByteArrayInputStream headerStream;

        protected ZipHeaderPeekInputStream(InputStream in) throws IOException {
            super(in);
            int len = in.read(this.header);
            this.headerStream = new ByteArrayInputStream(this.header, 0, len);
        }

        @Override
        public int read() throws IOException {
            int read;
            int n = read = this.headerStream == null ? -1 : this.headerStream.read();
            if (read != -1) {
                this.headerStream = null;
                return read;
            }
            return super.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read;
            int n = read = this.headerStream == null ? -1 : this.headerStream.read(b, off, len);
            if (read != -1) {
                this.headerStream = null;
                return read;
            }
            return super.read(b, off, len);
        }

        public boolean hasZipHeader() {
            return Arrays.equals(this.header, ZIP_HEADER);
        }
    }

    private static class InputStreamEntryWriter
    implements EntryWriter {
        private final InputStream inputStream;
        private final boolean close;

        InputStreamEntryWriter(InputStream inputStream, boolean close) {
            this.inputStream = inputStream;
            this.close = close;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            byte[] buffer = new byte[32768];
            int bytesRead = -1;
            while ((bytesRead = this.inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
            if (this.close) {
                this.inputStream.close();
            }
        }
    }

    private static interface EntryWriter {
        public void write(OutputStream var1) throws IOException;
    }
}

