/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.loader.tools.LibraryCoordinates;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.util.Assert;

public class Library {
    private final String name;
    private final @Nullable File file;
    private final @Nullable LibraryScope scope;
    private final @Nullable LibraryCoordinates coordinates;
    private final boolean unpackRequired;
    private final boolean local;
    private final boolean included;

    public Library(File file, LibraryScope scope) {
        this(null, file, scope, null, false, false, true);
    }

    public Library(@Nullable String name, @Nullable File file, @Nullable LibraryScope scope, @Nullable LibraryCoordinates coordinates, boolean unpackRequired, boolean local, boolean included) {
        this.name = name != null ? name : Library.getFileName(file);
        this.file = file;
        this.scope = scope;
        this.coordinates = coordinates;
        this.unpackRequired = unpackRequired;
        this.local = local;
        this.included = included;
    }

    private static String getFileName(@Nullable File file) {
        Assert.state((file != null ? 1 : 0) != 0, (String)"'file' must not be null");
        return file.getName();
    }

    public String getName() {
        return this.name;
    }

    public @Nullable File getFile() {
        return this.file;
    }

    InputStream openStream() throws IOException {
        Assert.state((this.file != null ? 1 : 0) != 0, (String)"'file' must not be null");
        return new FileInputStream(this.file);
    }

    public @Nullable LibraryScope getScope() {
        return this.scope;
    }

    public @Nullable LibraryCoordinates getCoordinates() {
        return this.coordinates;
    }

    public boolean isUnpackRequired() {
        return this.unpackRequired;
    }

    long getLastModified() {
        Assert.state((this.file != null ? 1 : 0) != 0, (String)"'file' must not be null");
        return this.file.lastModified();
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isIncluded() {
        return this.included;
    }
}

