/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;

public class ArtifactsLibraries
implements Libraries {
    private static final Map<String, LibraryScope> SCOPES;
    private final Set<Artifact> artifacts;
    private final Collection<Dependency> unpacks;

    public ArtifactsLibraries(Set<Artifact> artifacts, Collection<Dependency> unpacks) {
        this.artifacts = artifacts;
        this.unpacks = unpacks;
    }

    public void doWithLibraries(LibraryCallback callback) throws IOException {
        for (Artifact artifact : this.artifacts) {
            LibraryScope scope = SCOPES.get(artifact.getScope());
            if (scope == null || artifact.getFile() == null) continue;
            callback.library(new Library(artifact.getFile(), scope, this.isUnpackRequired(artifact)));
        }
    }

    private boolean isUnpackRequired(Artifact artifact) {
        if (this.unpacks != null) {
            for (Dependency unpack : this.unpacks) {
                if (!artifact.getGroupId().equals(unpack.getGroupId()) || !artifact.getArtifactId().equals(unpack.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HashMap<String, LibraryScope> scopes = new HashMap<String, LibraryScope>();
        scopes.put("compile", LibraryScope.COMPILE);
        scopes.put("runtime", LibraryScope.RUNTIME);
        scopes.put("provided", LibraryScope.PROVIDED);
        SCOPES = Collections.unmodifiableMap(scopes);
    }
}

