/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.springframework.boot.loader.tools.JavaExecutable;
import org.springframework.boot.loader.tools.RunProcess;
import org.springframework.boot.maven.AbstractRunMojo;

@Mojo(name="run", requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class RunMojo
extends AbstractRunMojo {
    @Override
    protected void runWithForkedJvm(List<String> args) throws MojoExecutionException {
        try {
            new RunProcess(new String[]{new JavaExecutable().toString()}).run(true, args.toArray(new String[args.size()]));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not exec java", ex);
        }
    }

    @Override
    protected void runWithMavenJvm(String startClassName, String ... arguments) throws MojoExecutionException {
        AbstractRunMojo.IsolatedThreadGroup threadGroup = new AbstractRunMojo.IsolatedThreadGroup(this, startClassName);
        Thread launchThread = new Thread(threadGroup, new AbstractRunMojo.LaunchRunner(this, startClassName, arguments), startClassName + ".main()");
        launchThread.setContextClassLoader(new URLClassLoader(this.getClassPathUrls()));
        launchThread.start();
        this.join(threadGroup);
        threadGroup.rethrowUncaughtException();
    }

    private void join(ThreadGroup threadGroup) {
        boolean hasNonDaemonThreads;
        do {
            hasNonDaemonThreads = false;
            Thread[] threads = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threads);
            for (Thread thread : threads) {
                if (thread == null || thread.isDaemon()) continue;
                try {
                    hasNonDaemonThreads = true;
                    thread.join();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (hasNonDaemonThreads);
    }
}

