/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.autoconfigure;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.EnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

class LogCorrelationEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    LogCorrelationEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (ClassUtils.isPresent((String)"io.micrometer.tracing.Tracer", (ClassLoader)application.getClassLoader())) {
            environment.getPropertySources().addLast((PropertySource)new LogCorrelationPropertySource(this, (Environment)environment));
        }
    }

    private static class LogCorrelationPropertySource
    extends EnumerablePropertySource<Object> {
        private static final String NAME = "logCorrelation";
        private final Environment environment;

        LogCorrelationPropertySource(Object source, Environment environment) {
            super(NAME, source);
            this.environment = environment;
        }

        public String[] getPropertyNames() {
            return new String[]{"logging.expect-correlation-id"};
        }

        public @Nullable Object getProperty(String name) {
            if (name.equals("logging.expect-correlation-id")) {
                return this.environment.getProperty("management.tracing.export.enabled", Boolean.class, (Object)Boolean.TRUE);
            }
            return null;
        }
    }
}

