/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.autoconfigure.prometheus;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.prometheus.metrics.tracer.common.SpanContext;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.micrometer.tracing.autoconfigure.MicrometerTracingAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.util.function.SingletonSupplier;

@AutoConfiguration(beforeName={"org.springframework.boot.micrometer.metrics.autoconfigure.export.prometheus.PrometheusMetricsExportAutoConfiguration"}, after={MicrometerTracingAutoConfiguration.class})
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={Tracer.class, SpanContext.class})
public final class PrometheusExemplarsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    SpanContext spanContext(ObjectProvider<Tracer> tracerProvider) {
        return new LazyTracingSpanContext(tracerProvider);
    }

    static class LazyTracingSpanContext
    implements SpanContext {
        private final SingletonSupplier<Tracer> tracer = SingletonSupplier.of(() -> tracerProvider.getObject());

        LazyTracingSpanContext(ObjectProvider<Tracer> tracerProvider) {
        }

        public @Nullable String getCurrentTraceId() {
            Span currentSpan = this.currentSpan();
            return currentSpan != null ? currentSpan.context().traceId() : null;
        }

        public @Nullable String getCurrentSpanId() {
            Span currentSpan = this.currentSpan();
            return currentSpan != null ? currentSpan.context().spanId() : null;
        }

        public boolean isCurrentSpanSampled() {
            Span currentSpan = this.currentSpan();
            if (currentSpan == null) {
                return false;
            }
            Boolean sampled = currentSpan.context().sampled();
            return sampled != null && sampled != false;
        }

        public void markCurrentSpanAsExemplar() {
        }

        private @Nullable Span currentSpan() {
            return ((Tracer)this.tracer.obtain()).currentSpan();
        }
    }
}

