/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.docker.compose;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcConnectionDetails;
import org.springframework.boot.r2dbc.docker.compose.ConnectionFactoryOptionsBuilder;
import org.springframework.boot.r2dbc.docker.compose.SqlServerEnvironment;

class SqlServerR2dbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<R2dbcConnectionDetails> {
    SqlServerR2dbcDockerComposeConnectionDetailsFactory() {
        super("mssql/server", new String[]{"io.r2dbc.spi.ConnectionFactoryOptions"});
    }

    protected R2dbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new SqlServerR2dbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class SqlServerR2dbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements R2dbcConnectionDetails {
        private static final ConnectionFactoryOptionsBuilder connectionFactoryOptionsBuilder = new ConnectionFactoryOptionsBuilder("mssql", 1433);
        private final ConnectionFactoryOptions connectionFactoryOptions;

        SqlServerR2dbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            SqlServerEnvironment environment = new SqlServerEnvironment(service.env());
            this.connectionFactoryOptions = connectionFactoryOptionsBuilder.build(service, "", environment.getUsername(), environment.getPassword());
        }

        @Override
        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return this.connectionFactoryOptions;
        }
    }
}

