/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.boot.restclient.RestClientCustomizer;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;

public class HttpMessageConvertersRestClientCustomizer
implements RestClientCustomizer {
    private final Iterable<? extends HttpMessageConverter<?>> messageConverters;

    public HttpMessageConvertersRestClientCustomizer(HttpMessageConverter<?> ... messageConverters) {
        Assert.notNull(messageConverters, (String)"'messageConverters' must not be null");
        this.messageConverters = Arrays.asList(messageConverters);
    }

    HttpMessageConvertersRestClientCustomizer(HttpMessageConverters messageConverters) {
        this.messageConverters = messageConverters;
    }

    @Override
    public void customize(RestClient.Builder restClientBuilder) {
        restClientBuilder.messageConverters(this::configureMessageConverters);
    }

    private void configureMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        if (this.messageConverters != null) {
            messageConverters.clear();
            this.messageConverters.forEach(messageConverters::add);
        }
    }
}

