/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.boot.restclient.RestTemplateCustomizer;
import org.springframework.boot.restclient.RestTemplateRequestCustomizer;
import org.springframework.util.ObjectUtils;

public final class RestTemplateBuilderConfigurer {
    private ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder;
    private ClientHttpRequestFactorySettings requestFactorySettings;
    private HttpMessageConverters httpMessageConverters;
    private List<RestTemplateCustomizer> restTemplateCustomizers;
    private List<RestTemplateRequestCustomizer<?>> restTemplateRequestCustomizers;

    void setRequestFactoryBuilder(ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder) {
        this.requestFactoryBuilder = requestFactoryBuilder;
    }

    void setRequestFactorySettings(ClientHttpRequestFactorySettings requestFactorySettings) {
        this.requestFactorySettings = requestFactorySettings;
    }

    void setHttpMessageConverters(HttpMessageConverters httpMessageConverters) {
        this.httpMessageConverters = httpMessageConverters;
    }

    void setRestTemplateCustomizers(List<RestTemplateCustomizer> restTemplateCustomizers) {
        this.restTemplateCustomizers = restTemplateCustomizers;
    }

    void setRestTemplateRequestCustomizers(List<RestTemplateRequestCustomizer<?>> restTemplateRequestCustomizers) {
        this.restTemplateRequestCustomizers = restTemplateRequestCustomizers;
    }

    public RestTemplateBuilder configure(RestTemplateBuilder builder) {
        if (this.requestFactoryBuilder != null) {
            builder = builder.requestFactoryBuilder(this.requestFactoryBuilder);
        }
        if (this.requestFactorySettings != null) {
            builder = builder.requestFactorySettings(this.requestFactorySettings);
        }
        if (this.httpMessageConverters != null) {
            builder = builder.messageConverters(this.httpMessageConverters.getConverters());
        }
        builder = this.addCustomizers(builder, this.restTemplateCustomizers, RestTemplateBuilder::customizers);
        builder = this.addCustomizers(builder, this.restTemplateRequestCustomizers, RestTemplateBuilder::requestCustomizers);
        return builder;
    }

    private <T> RestTemplateBuilder addCustomizers(RestTemplateBuilder builder, List<T> customizers, BiFunction<RestTemplateBuilder, Collection<T>, RestTemplateBuilder> method) {
        if (!ObjectUtils.isEmpty(customizers)) {
            return method.apply(builder, customizers);
        }
        return builder;
    }
}

