/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.oauth2.client.autoconfigure.reactive;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.security.oauth2.client.autoconfigure.reactive.ReactiveOAuth2ClientConfigurations;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import reactor.core.publisher.Flux;

@AutoConfiguration
@Conditional(value={NonServletApplicationCondition.class})
@ConditionalOnClass(value={Flux.class, ClientRegistration.class})
@Import(value={ReactiveOAuth2ClientConfigurations.ReactiveClientRegistrationRepositoryConfiguration.class, ReactiveOAuth2ClientConfigurations.ReactiveOAuth2AuthorizedClientServiceConfiguration.class})
public class ReactiveOAuth2ClientAutoConfiguration {

    static class NonServletApplicationCondition
    extends NoneNestedConditions {
        NonServletApplicationCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        static class ServletApplicationCondition {
            ServletApplicationCondition() {
            }
        }
    }
}

