/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import java.io.PrintStream;
import java.util.Collection;
import javax.servlet.Filter;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcBuilderCustomizer;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcPrint;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletContextInitializerBeans;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.PrintingResultHandler;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.WebApplicationContext;

public class SpringBootMockMvcBuilderCustomizer
implements MockMvcBuilderCustomizer {
    private final WebApplicationContext context;
    private boolean addFilters = true;
    private MockMvcPrint print = MockMvcPrint.DEFAULT;

    public SpringBootMockMvcBuilderCustomizer(WebApplicationContext context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        this.context = context;
    }

    @Override
    public void customize(ConfigurableMockMvcBuilder<?> builder) {
        ResultHandler printHandler;
        if (this.addFilters) {
            this.addFilters(builder);
        }
        if ((printHandler = this.getPrintHandler()) != null) {
            builder.alwaysDo(printHandler);
        }
    }

    private ResultHandler getPrintHandler() {
        if (this.print == MockMvcPrint.NONE) {
            return null;
        }
        if (this.print == MockMvcPrint.LOG_DEBUG) {
            return MockMvcResultHandlers.log();
        }
        return new SystemResultHandler(this.print);
    }

    private void addFilters(ConfigurableMockMvcBuilder<?> builder) {
        ServletContextInitializerBeans Initializers = new ServletContextInitializerBeans((ListableBeanFactory)this.context);
        for (ServletContextInitializer initializer : Initializers) {
            if (initializer instanceof FilterRegistrationBean) {
                this.addFilter(builder, (FilterRegistrationBean)initializer);
            }
            if (!(initializer instanceof DelegatingFilterProxyRegistrationBean)) continue;
            this.addFilter(builder, (DelegatingFilterProxyRegistrationBean)initializer);
        }
    }

    private void addFilter(ConfigurableMockMvcBuilder<?> builder, FilterRegistrationBean registration) {
        this.addFilter(builder, registration.getFilter(), registration.getUrlPatterns());
    }

    private void addFilter(ConfigurableMockMvcBuilder<?> builder, DelegatingFilterProxyRegistrationBean registration) {
        this.addFilter(builder, registration.getFilter(), registration.getUrlPatterns());
    }

    private void addFilter(ConfigurableMockMvcBuilder<?> builder, Filter filter, Collection<String> urls) {
        if (urls.isEmpty()) {
            builder.addFilters(new Filter[]{filter});
        } else {
            builder.addFilter(filter, urls.toArray(new String[urls.size()]));
        }
    }

    public void setAddFilters(boolean addFilters) {
        this.addFilters = addFilters;
    }

    public boolean isAddFilters() {
        return this.addFilters;
    }

    public void setPrint(MockMvcPrint print) {
        this.print = print;
    }

    public MockMvcPrint getPrint() {
        return this.print;
    }

    private static class SystemResultHandler
    extends PrintingResultHandler {
        protected SystemResultHandler(MockMvcPrint print) {
            super((PrintingResultHandler.ResultValuePrinter)new SystemResultValuePrinter(print));
        }

        private static class SystemResultValuePrinter
        implements PrintingResultHandler.ResultValuePrinter {
            private final MockMvcPrint print;

            SystemResultValuePrinter(MockMvcPrint print) {
                this.print = print;
            }

            public void printHeading(String heading) {
                this.getWriter().println();
                this.getWriter().println(String.format("%s:", heading));
            }

            public void printValue(String label, Object value) {
                if (value != null && value.getClass().isArray()) {
                    value = CollectionUtils.arrayToList((Object)value);
                }
                this.getWriter().println(String.format("%17s = %s", label, value));
            }

            private PrintStream getWriter() {
                if (this.print == MockMvcPrint.SYSTEM_ERR) {
                    return System.err;
                }
                return System.out;
            }
        }
    }
}

