/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.reactive;

import java.time.Duration;
import java.util.Collection;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.codec.CodecsAutoConfiguration;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ConditionalOnClass(value={WebClient.class, WebTestClient.class})
@AutoConfigureAfter(value={CodecsAutoConfiguration.class})
public class WebTestClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WebTestClient webTestClient(ApplicationContext applicationContext) {
        WebTestClient.Builder builder = WebTestClient.bindToApplicationContext((ApplicationContext)applicationContext).configureClient();
        this.customizeWebTestClient(builder, applicationContext);
        this.customizeWebTestClientCodecs(builder, applicationContext);
        return builder.build();
    }

    private void customizeWebTestClient(WebTestClient.Builder builder, ApplicationContext applicationContext) {
        Binder.get((Environment)applicationContext.getEnvironment()).bind("spring.test.webtestclient.timeout", Duration.class).ifBound(arg_0 -> ((WebTestClient.Builder)builder).responseTimeout(arg_0));
    }

    private void customizeWebTestClientCodecs(WebTestClient.Builder builder, ApplicationContext applicationContext) {
        Collection<CodecCustomizer> customizers = applicationContext.getBeansOfType(CodecCustomizer.class).values();
        if (!CollectionUtils.isEmpty(customizers)) {
            builder.exchangeStrategies(ExchangeStrategies.builder().codecs(this.applyCustomizers(customizers)).build());
        }
    }

    private Consumer<ClientCodecConfigurer> applyCustomizers(Collection<CodecCustomizer> customizers) {
        return codecs -> customizers.forEach(customizer -> customizer.customize((CodecConfigurer)codecs));
    }
}

