/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mockito.Answers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class MockDefinition
extends Definition {
    private static final int MULTIPLIER = 31;
    private final Class<?> classToMock;
    private final Set<Class<?>> extraInterfaces;
    private final Answers answer;
    private final boolean serializable;

    MockDefinition(Class<?> classToMock) {
        this(null, classToMock, null, null, false, null, true);
    }

    MockDefinition(String name, Class<?> classToMock, Class<?>[] extraInterfaces, Answers answer, boolean serializable, MockReset reset, boolean proxyTargetAware) {
        super(name, reset, proxyTargetAware);
        Assert.notNull(classToMock, (String)"ClassToMock must not be null");
        this.classToMock = classToMock;
        this.extraInterfaces = this.asClassSet(extraInterfaces);
        this.answer = answer != null ? answer : Answers.RETURNS_DEFAULTS;
        this.serializable = serializable;
    }

    private Set<Class<?>> asClassSet(Class<?>[] classes) {
        LinkedHashSet classSet = new LinkedHashSet();
        if (classes != null) {
            classSet.addAll(Arrays.asList(classes));
        }
        return Collections.unmodifiableSet(classSet);
    }

    public Class<?> getClassToMock() {
        return this.classToMock;
    }

    public Set<Class<?>> getExtraInterfaces() {
        return this.extraInterfaces;
    }

    public Answers getAnswer() {
        return this.answer;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.classToMock);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.extraInterfaces);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.answer);
        result = 31 * result + (this.serializable ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MockDefinition other = (MockDefinition)obj;
        boolean result = super.equals(obj);
        result &= ObjectUtils.nullSafeEquals(this.classToMock, other.classToMock);
        result &= ObjectUtils.nullSafeEquals(this.extraInterfaces, other.extraInterfaces);
        result &= ObjectUtils.nullSafeEquals((Object)this.answer, (Object)other.answer);
        return result &= this.serializable == other.serializable;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.getName()).append("classToMock", this.classToMock).append("extraInterfaces", this.extraInterfaces).append("answer", (Object)this.answer).append("serializable", this.serializable).append("reset", (Object)this.getReset()).toString();
    }

    public <T> T createMock() {
        return this.createMock(this.getName());
    }

    public <T> T createMock(String name) {
        MockSettings settings = MockReset.withSettings(this.getReset());
        if (StringUtils.hasLength((String)name)) {
            settings.name(name);
        }
        if (!this.extraInterfaces.isEmpty()) {
            settings.extraInterfaces(this.extraInterfaces.toArray(new Class[0]));
        }
        settings.defaultAnswer(this.answer.get());
        if (this.serializable) {
            settings.serializable();
        }
        return (T)Mockito.mock(this.classToMock, (MockSettings)settings);
    }
}

