/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.context.annotation.UserConfigurations;
import org.springframework.boot.test.context.AssertProviderApplicationContext;
import org.springframework.boot.test.context.ContextConsumer;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

abstract class AbstractApplicationContextTester<SELF extends AbstractApplicationContextTester<SELF, C, A>, C extends ConfigurableApplicationContext, A extends AssertProviderApplicationContext<C>> {
    private final Supplier<C> contextFactory;
    private final TestPropertyValues environmentProperties;
    private final TestPropertyValues systemProperties;
    private ClassLoader classLoader;
    private ApplicationContext parent;
    private final List<Configurations> configurations = new ArrayList<Configurations>();

    protected AbstractApplicationContextTester(Supplier<C> contextFactory) {
        Assert.notNull(contextFactory, (String)"ContextFactory must not be null");
        this.contextFactory = contextFactory;
        this.environmentProperties = TestPropertyValues.empty();
        this.systemProperties = TestPropertyValues.empty();
    }

    public SELF withPropertyValues(String ... pairs) {
        Arrays.stream(pairs).forEach(this.environmentProperties::and);
        return this.self();
    }

    public SELF withPropertyValue(String name, String value) {
        this.environmentProperties.and(name, value);
        return this.self();
    }

    public SELF withSystemProperties(String ... pairs) {
        Arrays.stream(pairs).forEach(this.systemProperties::and);
        return this.self();
    }

    public SELF withSystemProperty(String name, String value) {
        this.systemProperties.and(name, value);
        return this.self();
    }

    public SELF withClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this.self();
    }

    public SELF withParent(ApplicationContext parent) {
        this.parent = parent;
        return this.self();
    }

    public SELF withUserConfiguration(Class<?> ... configurationClasses) {
        return this.withConfiguration((Configurations)UserConfigurations.of((Class[])configurationClasses));
    }

    public SELF withConfiguration(Configurations configurations) {
        Assert.notNull((Object)configurations, (String)"Configurations must not be null");
        this.configurations.add(configurations);
        return this.self();
    }

    protected final SELF self() {
        return (SELF)this;
    }

    public void run(ContextConsumer<? super A> consumer) {
        this.systemProperties.applyToSystemProperties(() -> {
            try (A context = this.createAssertableContext();){
                this.accept(consumer, context);
            }
            return null;
        });
    }

    private A createAssertableContext() {
        ResolvableType resolvableType = ResolvableType.forClass(AbstractApplicationContextTester.class, this.getClass());
        Class assertType = resolvableType.resolveGeneric(new int[]{1});
        Class contextType = resolvableType.resolveGeneric(new int[]{2});
        return (A)AssertProviderApplicationContext.get(assertType, contextType, this::createAndLoadContext);
    }

    private C createAndLoadContext() {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)this.contextFactory.get();
        try {
            this.configureContext(context);
            return (C)context;
        }
        catch (RuntimeException ex) {
            context.close();
            throw ex;
        }
    }

    private void configureContext(C context) {
        if (this.parent != null) {
            context.setParent(this.parent);
        }
        if (this.classLoader != null) {
            Assert.isInstanceOf(DefaultResourceLoader.class, context);
            ((DefaultResourceLoader)context).setClassLoader(this.classLoader);
        }
        this.environmentProperties.applyTo((ConfigurableApplicationContext)context);
        Class[] classes = Configurations.getClasses(this.configurations);
        if (classes.length > 0) {
            ((AnnotationConfigRegistry)context).register(classes);
        }
        context.refresh();
    }

    private void accept(ContextConsumer<? super A> consumer, A context) {
        try {
            consumer.accept(context);
        }
        catch (Throwable ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
        }
    }
}

