/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.Answers;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.matchers.LocalizedMatcher;
import org.mockito.internal.progress.ArgumentMatcherStorage;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.verification.MockAwareVerificationMode;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

abstract class MockitoApi {
    private static final MockitoApi api = MockitoApi.createApi();

    MockitoApi() {
    }

    public abstract MockCreationSettings<?> getMockSettings(Object var1);

    public abstract MockingProgress mockingProgress(Object var1);

    public abstract void reportMatchers(ArgumentMatcherStorage var1, List<LocalizedMatcher> var2);

    public abstract MockAwareVerificationMode createMockAwareVerificationMode(Object var1, VerificationMode var2);

    public abstract Answer<Object> getAnswer(Answers var1);

    private static MockitoApi createApi() {
        if (ClassUtils.isPresent((String)"org.mockito.ReturnValues", null)) {
            return new Mockito1Api();
        }
        return new Mockito2Api();
    }

    public static MockitoApi get() {
        return api;
    }

    private static class Mockito2Api
    extends MockitoApi {
        private Mockito2Api() {
        }

        @Override
        public MockCreationSettings<?> getMockSettings(Object mock) {
            return MockUtil.getMockSettings((Object)mock);
        }

        @Override
        public MockingProgress mockingProgress(Object mock) {
            return ThreadSafeMockingProgress.mockingProgress();
        }

        @Override
        public void reportMatchers(ArgumentMatcherStorage storage, List<LocalizedMatcher> matchers) {
            for (LocalizedMatcher matcher : matchers) {
                storage.reportMatcher(matcher.getMatcher());
            }
        }

        @Override
        public MockAwareVerificationMode createMockAwareVerificationMode(Object mock, VerificationMode mode) {
            try {
                return new MockAwareVerificationMode(mock, mode, Collections.emptySet());
            }
            catch (NoSuchMethodError ex) {
                Constructor constructor = ClassUtils.getConstructorIfAvailable(MockAwareVerificationMode.class, (Class[])new Class[]{Object.class, VerificationMode.class});
                if (constructor == null) {
                    throw ex;
                }
                return (MockAwareVerificationMode)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{mock, mode});
            }
        }

        @Override
        public Answer<Object> getAnswer(Answers answer) {
            return answer;
        }
    }

    private static class Mockito1Api
    extends MockitoApi {
        private final MockUtil mockUtil = (MockUtil)BeanUtils.instantiateClass(MockUtil.class);
        private final Method getMockSettingsMethod = ReflectionUtils.findMethod(MockUtil.class, (String)"getMockSettings", (Class[])new Class[]{Object.class});
        private final Method getMockHandlerMethod = ReflectionUtils.findMethod(MockUtil.class, (String)"getMockHandler", (Class[])new Class[]{Object.class});
        private Method reportMatcherMethod = ReflectionUtils.findMethod(ArgumentMatcherStorage.class, (String)"reportMatcher", (Class[])new Class[]{Matcher.class});
        private Constructor<MockAwareVerificationMode> mockAwareVerificationModeConstructor = ClassUtils.getConstructorIfAvailable(MockAwareVerificationMode.class, (Class[])new Class[]{Object.class, VerificationMode.class});

        Mockito1Api() {
        }

        @Override
        public MockCreationSettings<?> getMockSettings(Object mock) {
            return (MockCreationSettings)ReflectionUtils.invokeMethod((Method)this.getMockSettingsMethod, (Object)this.mockUtil, (Object[])new Object[]{mock});
        }

        @Override
        public MockingProgress mockingProgress(Object mock) {
            InternalMockHandler handler = (InternalMockHandler)ReflectionUtils.invokeMethod((Method)this.getMockHandlerMethod, (Object)this.mockUtil, (Object[])new Object[]{mock});
            InvocationContainer container = handler.getInvocationContainer();
            Field field = ReflectionUtils.findField(container.getClass(), (String)"mockingProgress");
            ReflectionUtils.makeAccessible((Field)field);
            return (MockingProgress)ReflectionUtils.getField((Field)field, (Object)container);
        }

        @Override
        public void reportMatchers(ArgumentMatcherStorage storage, List<LocalizedMatcher> matchers) {
            for (LocalizedMatcher matcher : matchers) {
                ReflectionUtils.invokeMethod((Method)this.reportMatcherMethod, (Object)storage, (Object[])new Object[]{matcher});
            }
        }

        @Override
        public MockAwareVerificationMode createMockAwareVerificationMode(Object mock, VerificationMode mode) {
            return (MockAwareVerificationMode)BeanUtils.instantiateClass(this.mockAwareVerificationModeConstructor, (Object[])new Object[]{mock, mode});
        }

        @Override
        public Answer<Object> getAnswer(Answers answer) {
            return answer.get();
        }
    }
}

