/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.mockito.internal.matchers.LocalizedMatcher;
import org.mockito.internal.progress.ArgumentMatcherStorage;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.verification.MockAwareVerificationMode;
import org.mockito.verification.VerificationMode;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.util.AopTestUtils;
import org.springframework.util.Assert;

class MockitoAopProxyTargetInterceptor
implements MethodInterceptor {
    private final Object source;
    private final Object target;
    private final Verification verification = new Verification();

    MockitoAopProxyTargetInterceptor(Object source, Object target) throws Exception {
        this.source = source;
        this.target = target;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.verification.isVerifying()) {
            this.verification.replaceVerifyMock(this.source, this.target);
            return AopUtils.invokeJoinpointUsingReflection((Object)this.target, (Method)invocation.getMethod(), (Object[])invocation.getArguments());
        }
        return invocation.proceed();
    }

    @Autowired
    public static void applyTo(Object source) {
        Assert.state((boolean)AopUtils.isAopProxy((Object)source), (String)"Source must be an AOP proxy");
        try {
            Advised advised = (Advised)source;
            for (Advisor advisor : advised.getAdvisors()) {
                if (!(advisor instanceof MockitoAopProxyTargetInterceptor)) continue;
                return;
            }
            Object target = AopTestUtils.getUltimateTargetObject((Object)source);
            MockitoAopProxyTargetInterceptor advice = new MockitoAopProxyTargetInterceptor(source, target);
            advised.addAdvice(0, (Advice)advice);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to apply Mockito AOP support", ex);
        }
    }

    private static class Verification {
        private final Object monitor = new Object();
        private final MockingProgress progress = ThreadSafeMockingProgress.mockingProgress();

        private Verification() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isVerifying() {
            Object object = this.monitor;
            synchronized (object) {
                VerificationMode mode = this.progress.pullVerificationMode();
                if (mode != null) {
                    this.resetVerificationStarted(mode);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceVerifyMock(Object source, Object target) {
            Object object = this.monitor;
            synchronized (object) {
                VerificationMode mode = this.progress.pullVerificationMode();
                if (mode != null) {
                    MockAwareVerificationMode mockAwareMode;
                    if (mode instanceof MockAwareVerificationMode && (mockAwareMode = (MockAwareVerificationMode)mode).getMock() == source) {
                        mode = new MockAwareVerificationMode(target, mode, Collections.emptySet());
                    }
                    this.resetVerificationStarted(mode);
                }
            }
        }

        private void resetVerificationStarted(VerificationMode mode) {
            ArgumentMatcherStorage storage = this.progress.getArgumentMatcherStorage();
            List matchers = storage.pullLocalizedMatchers();
            this.progress.verificationStarted(mode);
            matchers.stream().map(LocalizedMatcher::getMatcher).forEach(arg_0 -> ((ArgumentMatcherStorage)storage).reportMatcher(arg_0));
        }
    }
}

