/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.system;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.test.system.CapturedOutput;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class OutputCapture
implements CapturedOutput {
    private final Deque<SystemCapture> systemCaptures = new ArrayDeque<SystemCapture>();
    private AnsiOutputState ansiOutputState;

    OutputCapture() {
    }

    final void push() {
        if (this.systemCaptures.isEmpty()) {
            this.ansiOutputState = AnsiOutputState.saveAndDisable();
        }
        this.systemCaptures.addLast(new SystemCapture());
    }

    final void pop() {
        this.systemCaptures.removeLast().release();
        if (this.systemCaptures.isEmpty() && this.ansiOutputState != null) {
            this.ansiOutputState.restore();
            this.ansiOutputState = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CapturedOutput || obj instanceof CharSequence) {
            return this.getAll().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return this.getAll();
    }

    @Override
    public String getAll() {
        return this.get(type -> true);
    }

    @Override
    public String getOut() {
        return this.get(Type.OUT::equals);
    }

    @Override
    public String getErr() {
        return this.get(Type.ERR::equals);
    }

    void reset() {
        this.systemCaptures.peek().reset();
    }

    private String get(Predicate<Type> filter) {
        Assert.state((!this.systemCaptures.isEmpty() ? 1 : 0) != 0, (String)"No system captures found. Check that you have used @ExtendWith.");
        StringBuilder builder = new StringBuilder();
        for (SystemCapture systemCapture : this.systemCaptures) {
            systemCapture.append(builder, filter);
        }
        return builder.toString();
    }

    private static class AnsiOutputState {
        private AnsiOutput.Enabled saved = AnsiOutput.getEnabled();

        AnsiOutputState() {
            AnsiOutput.setEnabled((AnsiOutput.Enabled)AnsiOutput.Enabled.NEVER);
        }

        public void restore() {
            AnsiOutput.setEnabled((AnsiOutput.Enabled)this.saved);
        }

        public static AnsiOutputState saveAndDisable() {
            if (!ClassUtils.isPresent((String)"org.springframework.boot.ansi.AnsiOutput", (ClassLoader)OutputCapture.class.getClassLoader())) {
                return null;
            }
            return new AnsiOutputState();
        }
    }

    private static enum Type {
        OUT,
        ERR;

    }

    private static class CapturedString {
        private final Type type;
        private final String string;

        CapturedString(Type type, String string) {
            this.type = type;
            this.string = string;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.string;
        }
    }

    private static class OutputStreamCapture
    extends OutputStream {
        private final PrintStream systemStream;
        private final Consumer<String> copy;

        OutputStreamCapture(PrintStream systemStream, Consumer<String> copy) {
            this.systemStream = systemStream;
            this.copy = copy;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(b & 0xFF)});
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.copy.accept(new String(b, off, len));
            this.systemStream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.systemStream.flush();
        }
    }

    private static class PrintStreamCapture
    extends PrintStream {
        private final PrintStream parent;

        PrintStreamCapture(PrintStream parent, Consumer<String> copy) {
            super(new OutputStreamCapture(PrintStreamCapture.getSystemStream(parent), copy));
            this.parent = parent;
        }

        public PrintStream getParent() {
            return this.parent;
        }

        private static PrintStream getSystemStream(PrintStream printStream) {
            if (printStream instanceof PrintStreamCapture) {
                return ((PrintStreamCapture)printStream).getParent();
            }
            return printStream;
        }
    }

    private static class SystemCapture {
        private final Object monitor = new Object();
        private final PrintStreamCapture out;
        private final PrintStreamCapture err;
        private final List<CapturedString> capturedStrings = new ArrayList<CapturedString>();

        SystemCapture() {
            this.out = new PrintStreamCapture(System.out, this::captureOut);
            this.err = new PrintStreamCapture(System.err, this::captureErr);
            System.setOut(this.out);
            System.setErr(this.err);
        }

        public void release() {
            System.setOut(this.out.getParent());
            System.setErr(this.err.getParent());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void captureOut(String string) {
            Object object = this.monitor;
            synchronized (object) {
                this.capturedStrings.add(new CapturedString(Type.OUT, string));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void captureErr(String string) {
            Object object = this.monitor;
            synchronized (object) {
                this.capturedStrings.add(new CapturedString(Type.ERR, string));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void append(StringBuilder builder, Predicate<Type> filter) {
            Object object = this.monitor;
            synchronized (object) {
                for (CapturedString stringCapture : this.capturedStrings) {
                    if (!filter.test(stringCapture.getType())) continue;
                    builder.append(stringCapture);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.monitor;
            synchronized (object) {
                this.capturedStrings.clear();
            }
        }
    }
}

