/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.Cookie;
import org.springframework.boot.web.server.servlet.ServletWebServerSettings;
import org.springframework.boot.web.server.servlet.Session;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.lang.Contract;

public final class ServletContextInitializers
implements Iterable<ServletContextInitializer> {
    private final List<ServletContextInitializer> initializers;

    private ServletContextInitializers(List<ServletContextInitializer> initializers) {
        this.initializers = initializers;
    }

    @Override
    public Iterator<ServletContextInitializer> iterator() {
        return this.initializers.iterator();
    }

    public static ServletContextInitializers from(ServletWebServerSettings settings, ServletContextInitializer ... initializers) {
        ArrayList<ServletContextInitializer> mergedInitializers = new ArrayList<ServletContextInitializer>();
        mergedInitializers.add(servletContext -> settings.getInitParameters().forEach((arg_0, arg_1) -> ((ServletContext)servletContext).setInitParameter(arg_0, arg_1)));
        mergedInitializers.add(new SessionConfiguringInitializer(settings.getSession()));
        mergedInitializers.addAll(Arrays.asList(initializers));
        mergedInitializers.addAll(settings.getInitializers());
        return new ServletContextInitializers(mergedInitializers);
    }

    private static final class SessionConfiguringInitializer
    implements ServletContextInitializer {
        private final Session session;

        private SessionConfiguringInitializer(Session session) {
            this.session = session;
        }

        public void onStartup(ServletContext servletContext) throws ServletException {
            if (this.session.getTrackingModes() != null) {
                servletContext.setSessionTrackingModes(this.unwrap(this.session.getTrackingModes()));
            }
            this.configureSessionCookie(servletContext.getSessionCookieConfig());
        }

        private void configureSessionCookie(SessionCookieConfig config) {
            Cookie cookie = this.session.getCookie();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(cookie::getName).to(arg_0 -> ((SessionCookieConfig)config).setName(arg_0));
            map.from(cookie::getDomain).to(arg_0 -> ((SessionCookieConfig)config).setDomain(arg_0));
            map.from(cookie::getPath).to(arg_0 -> ((SessionCookieConfig)config).setPath(arg_0));
            map.from(cookie::getHttpOnly).to(arg_0 -> ((SessionCookieConfig)config).setHttpOnly(arg_0));
            map.from(cookie::getSecure).to(arg_0 -> ((SessionCookieConfig)config).setSecure(arg_0));
            map.from(cookie::getMaxAge).asInt(Duration::getSeconds).to(arg_0 -> ((SessionCookieConfig)config).setMaxAge(arg_0));
            map.from(cookie::getPartitioned).as(Object::toString).to(partitioned -> config.setAttribute("Partitioned", partitioned));
        }

        @Contract(value="!null -> !null")
        private @Nullable Set<SessionTrackingMode> unwrap(@Nullable Set<Session.SessionTrackingMode> modes) {
            if (modes == null) {
                return null;
            }
            LinkedHashSet<SessionTrackingMode> result = new LinkedHashSet<SessionTrackingMode>();
            for (Session.SessionTrackingMode mode : modes) {
                result.add(SessionTrackingMode.valueOf((String)mode.name()));
            }
            return result;
        }
    }
}

