/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.Banner;
import org.springframework.boot.BeanDefinitionLoader;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplicationInitializer;
import org.springframework.boot.StartupInfoLogger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.StandardServletEnvironment;

public class SpringApplication {
    private static final String DEFAULT_CONTEXT_CLASS = "org.springframework.context.annotation.AnnotationConfigApplicationContext";
    public static final String DEFAULT_WEB_CONTEXT_CLASS = "org.springframework.boot.context.embedded.AnnotationConfigEmbeddedWebApplicationContext";
    private static final String[] WEB_ENVIRONMENT_CLASSES = new String[]{"javax.servlet.Servlet", "org.springframework.web.context.ConfigurableWebApplicationContext"};
    private final Log log = LogFactory.getLog(this.getClass());
    private Set<Object> sources = new LinkedHashSet<Object>();
    private Set<Object> initialSources = new LinkedHashSet<Object>();
    private Class<?> mainApplicationClass;
    private boolean showBanner = true;
    private boolean logStartupInfo = true;
    private boolean addCommandLineProperties = true;
    private ResourceLoader resourceLoader;
    private BeanNameGenerator beanNameGenerator;
    private ConfigurableEnvironment environment;
    private ApplicationContext applicationContext;
    private Class<? extends ApplicationContext> applicationContextClass;
    private boolean webEnvironment;
    private List<ApplicationContextInitializer<?>> initializers;
    private String[] defaultArgs;

    public SpringApplication(Object ... sources) {
        this.initialize(sources);
    }

    public SpringApplication(ResourceLoader resourceLoader, Object ... sources) {
        this.resourceLoader = resourceLoader;
        this.initialize(sources);
    }

    private void initialize(Object[] sources) {
        if (sources != null && sources.length > 0) {
            this.initialSources.addAll(Arrays.asList(sources));
        }
        this.webEnvironment = this.deduceWebEnvironment();
        this.initializers = new ArrayList();
        this.initializers.addAll(this.getSpringFactoriesApplicationContextInitializers());
        this.mainApplicationClass = this.deduceMainApplicationClass();
    }

    private boolean deduceWebEnvironment() {
        for (String className : WEB_ENVIRONMENT_CLASSES) {
            if (ClassUtils.isPresent((String)className, null)) continue;
            return false;
        }
        return true;
    }

    protected Collection<ApplicationContextInitializer<?>> getSpringFactoriesApplicationContextInitializers() {
        return SpringFactoriesLoader.loadFactories(ApplicationContextInitializer.class, (ClassLoader)SpringApplication.class.getClassLoader());
    }

    private Class<?> deduceMainApplicationClass() {
        try {
            StackTraceElement[] stackTrace;
            for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
                if (!"main".equals(stackTraceElement.getMethodName())) continue;
                return Class.forName(stackTraceElement.getClassName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public ApplicationContext run(String ... args) {
        ApplicationContext context;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.callNonEnvironmentAwareSpringApplicationInitializers(args);
        ConfigurableEnvironment environment = this.getOrCreateEnvironment();
        this.addPropertySources(environment, args);
        this.callEnvironmentAwareSpringApplicationInitializers(args, environment);
        Set<Object> sources = this.assembleSources();
        Assert.notEmpty(sources, (String)"Sources must not be empty");
        if (this.showBanner) {
            this.printBanner();
        }
        if ((context = this.createApplicationContext()) instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)context).registerShutdownHook();
            ((ConfigurableApplicationContext)context).setEnvironment(environment);
        }
        this.postProcessApplicationContext(context);
        if (context instanceof ConfigurableApplicationContext) {
            this.applyInitializers((ConfigurableApplicationContext)context);
        }
        if (this.logStartupInfo) {
            this.logStartupInfo();
        }
        this.load(context, sources.toArray(new Object[sources.size()]));
        this.refresh(context);
        stopWatch.stop();
        if (this.logStartupInfo) {
            new StartupInfoLogger(this.mainApplicationClass).logStarted(this.getApplicationLog(), stopWatch);
        }
        this.runCommandLineRunners(context, args);
        return context;
    }

    private Set<Object> assembleSources() {
        LinkedHashSet<Object> sources = new LinkedHashSet<Object>();
        sources.addAll(this.sources);
        sources.addAll(this.initialSources);
        return sources;
    }

    private void callNonEnvironmentAwareSpringApplicationInitializers(String[] args) {
        for (ApplicationContextInitializer<?> initializer : this.initializers) {
            if (!(initializer instanceof SpringApplicationInitializer) || initializer instanceof EnvironmentAware) continue;
            ((SpringApplicationInitializer)initializer).initialize(this, args);
        }
    }

    private ConfigurableEnvironment getOrCreateEnvironment() {
        if (this.environment != null) {
            return this.environment;
        }
        if (this.applicationContext != null && this.applicationContext.getEnvironment() instanceof ConfigurableEnvironment) {
            return (ConfigurableEnvironment)this.applicationContext.getEnvironment();
        }
        if (this.webEnvironment) {
            return new StandardServletEnvironment();
        }
        return new StandardEnvironment();
    }

    protected void addPropertySources(ConfigurableEnvironment environment, String[] args) {
        if (this.addCommandLineProperties) {
            if (this.defaultArgs != null) {
                environment.getPropertySources().addFirst((PropertySource)new SimpleCommandLinePropertySource("defaultCommandLineArgs", this.defaultArgs));
            }
            environment.getPropertySources().addFirst((PropertySource)new SimpleCommandLinePropertySource(args));
        }
    }

    private void callEnvironmentAwareSpringApplicationInitializers(String[] args, ConfigurableEnvironment environment) {
        for (ApplicationContextInitializer<?> initializer : this.initializers) {
            if (!(initializer instanceof SpringApplicationInitializer) || !(initializer instanceof EnvironmentAware)) continue;
            ((EnvironmentAware)initializer).setEnvironment((Environment)environment);
            ((SpringApplicationInitializer)initializer).initialize(this, args);
        }
    }

    protected void printBanner() {
        Banner.write(System.out);
    }

    protected void applyInitializers(ConfigurableApplicationContext context) {
        for (ApplicationContextInitializer<?> initializer : this.initializers) {
            Class requiredType = GenericTypeResolver.resolveTypeArgument(initializer.getClass(), ApplicationContextInitializer.class);
            Assert.isInstanceOf((Class)requiredType, (Object)context, (String)"Unable to call initializer.");
            initializer.initialize(context);
        }
    }

    protected void logStartupInfo() {
        new StartupInfoLogger(this.mainApplicationClass).logStarting(this.getApplicationLog());
    }

    protected Log getApplicationLog() {
        if (this.mainApplicationClass == null) {
            return this.log;
        }
        return LogFactory.getLog(this.mainApplicationClass);
    }

    protected ApplicationContext createApplicationContext() {
        if (this.applicationContext != null) {
            return this.applicationContext;
        }
        Class<Object> contextClass = this.applicationContextClass;
        if (contextClass == null) {
            try {
                contextClass = Class.forName(this.webEnvironment ? DEFAULT_WEB_CONTEXT_CLASS : DEFAULT_CONTEXT_CLASS);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Unable create a default ApplicationContext, please specify an ApplicationContextClass", ex);
            }
        }
        return (ApplicationContext)BeanUtils.instantiate(contextClass);
    }

    protected void postProcessApplicationContext(ApplicationContext context) {
        if (this.webEnvironment && context instanceof ConfigurableWebApplicationContext) {
            ConfigurableWebApplicationContext configurableContext = (ConfigurableWebApplicationContext)context;
            if (this.beanNameGenerator != null) {
                configurableContext.getBeanFactory().registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", (Object)this.beanNameGenerator);
            }
        }
        if (context instanceof GenericApplicationContext && this.resourceLoader != null) {
            ((GenericApplicationContext)context).setResourceLoader(this.resourceLoader);
        }
    }

    protected void load(ApplicationContext context, Object[] sources) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading source " + StringUtils.arrayToCommaDelimitedString((Object[])sources)));
        }
        BeanDefinitionLoader loader = this.createBeanDefinitionLoader(this.getBeanDefinitionRegistry(context), sources);
        if (this.beanNameGenerator != null) {
            loader.setBeanNameGenerator(this.beanNameGenerator);
        }
        if (this.resourceLoader != null) {
            loader.setResourceLoader(this.resourceLoader);
        }
        if (this.environment != null) {
            loader.setEnvironment(this.environment);
        }
        loader.load();
    }

    private BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext context) {
        if (context instanceof BeanDefinitionRegistry) {
            return (BeanDefinitionRegistry)context;
        }
        throw new IllegalStateException("Could not locate BeanDefinitionRegistry");
    }

    protected BeanDefinitionLoader createBeanDefinitionLoader(BeanDefinitionRegistry registry, Object[] sources) {
        return new BeanDefinitionLoader(registry, sources);
    }

    private void runCommandLineRunners(ApplicationContext context, String ... args) {
        ArrayList runners = new ArrayList(context.getBeansOfType(CommandLineRunner.class).values());
        AnnotationAwareOrderComparator.sort(runners);
        for (CommandLineRunner runner : runners) {
            try {
                runner.run(args);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to execute CommandLineRunner", ex);
            }
        }
    }

    protected void refresh(ApplicationContext applicationContext) {
        Assert.isInstanceOf(AbstractApplicationContext.class, (Object)applicationContext);
        ((AbstractApplicationContext)applicationContext).refresh();
    }

    public void setMainApplicationClass(Class<?> mainApplicationClass) {
        this.mainApplicationClass = mainApplicationClass;
    }

    public void setWebEnvironment(boolean webEnvironment) {
        this.webEnvironment = webEnvironment;
    }

    public void setShowBanner(boolean showBanner) {
        this.showBanner = showBanner;
    }

    public void setLogStartupInfo(boolean logStartupInfo) {
        this.logStartupInfo = logStartupInfo;
    }

    public void setAddCommandLineProperties(boolean addCommandLineProperties) {
        this.addCommandLineProperties = addCommandLineProperties;
    }

    public void setDefaultArgs(String ... defaultArgs) {
        this.defaultArgs = defaultArgs;
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public Set<Object> getSources() {
        return this.sources;
    }

    public void setSources(Set<Object> sources) {
        Assert.notNull(sources, (String)"Sources must not be null");
        this.sources = new LinkedHashSet<Object>(sources);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContextClass(Class<? extends ApplicationContext> applicationContextClass) {
        this.applicationContextClass = applicationContextClass;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setInitializers(Collection<? extends ApplicationContextInitializer<?>> initializers) {
        this.initializers = new ArrayList(initializers);
    }

    public void addInitializers(ApplicationContextInitializer<?> ... initializers) {
        this.initializers.addAll(Arrays.asList(initializers));
    }

    public List<ApplicationContextInitializer<?>> getInitializers() {
        return this.initializers;
    }

    public static ApplicationContext run(Object source, String ... args) {
        return SpringApplication.run(new Object[]{source}, args);
    }

    public static ApplicationContext run(Object[] sources, String[] args) {
        return new SpringApplication(sources).run(args);
    }

    public static void main(String[] args) throws Exception {
        SpringApplication.run(new Object[0], args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int exit(ApplicationContext context, ExitCodeGenerator ... exitCodeGenerators) {
        int exitCode = 0;
        try {
            try {
                ArrayList<ExitCodeGenerator> generators = new ArrayList<ExitCodeGenerator>();
                generators.addAll(Arrays.asList(exitCodeGenerators));
                generators.addAll(context.getBeansOfType(ExitCodeGenerator.class).values());
                exitCode = SpringApplication.getExitCode(generators);
            }
            finally {
                SpringApplication.close(context);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exitCode = exitCode == 0 ? 1 : exitCode;
        }
        return exitCode;
    }

    private static int getExitCode(List<ExitCodeGenerator> exitCodeGenerators) {
        int exitCode = 0;
        for (ExitCodeGenerator exitCodeGenerator : exitCodeGenerators) {
            try {
                int value = exitCodeGenerator.getExitCode();
                if ((value <= 0 || value <= exitCode) && (value >= 0 || value >= exitCode)) continue;
                exitCode = value;
            }
            catch (Exception ex) {
                exitCode = exitCode == 0 ? 1 : exitCode;
                ex.printStackTrace();
            }
        }
        return exitCode;
    }

    private static void close(ApplicationContext context) {
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext closable = (ConfigurableApplicationContext)context;
            closable.close();
        }
    }
}

