/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Validation;
import javax.validation.constraints.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.bind.YamlConfigurationFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.validation.BindException;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlConfigurationFactoryTests {
    private YamlConfigurationFactory<Foo> factory;
    private Validator validator;
    private Map<Class<?>, Map<String, String>> aliases = new HashMap();

    private Foo createFoo(String yaml) throws Exception {
        this.factory = new YamlConfigurationFactory(Foo.class);
        this.factory.setYaml(yaml);
        this.factory.setExceptionIfInvalid(true);
        this.factory.setPropertyAliases(this.aliases);
        this.factory.setValidator(this.validator);
        this.factory.setMessageSource((MessageSource)new StaticMessageSource());
        this.factory.afterPropertiesSet();
        return (Foo)this.factory.getObject();
    }

    @Test
    public void testValidYamlLoadsWithNoErrors() throws Exception {
        Foo foo = this.createFoo("name: blah\nbar: blah");
        Assert.assertEquals((Object)"blah", (Object)foo.bar);
    }

    @Test
    public void testValidYamlWithAliases() throws Exception {
        this.aliases.put(Foo.class, Collections.singletonMap("foo-name", "name"));
        Foo foo = this.createFoo("foo-name: blah\nbar: blah");
        Assert.assertEquals((Object)"blah", (Object)foo.name);
    }

    @Test(expected=YAMLException.class)
    public void unknownPropertyCausesLoadFailure() throws Exception {
        this.createFoo("hi: hello\nname: foo\nbar: blah");
    }

    @Test(expected=BindException.class)
    public void missingPropertyCausesValidationError() throws Exception {
        this.validator = new SpringValidatorAdapter(Validation.buildDefaultValidatorFactory().getValidator());
        this.createFoo("bar: blah");
    }

    private static class Foo {
        @NotNull
        public String name;
        public String bar;

        private Foo() {
        }
    }
}

