/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.builder;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class SpringApplicationBuilderTests {
    private ConfigurableApplicationContext context;

    @After
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void profileAndProperties() throws Exception {
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[0]).sources(new Class[]{ExampleConfig.class}).contextClass(StaticApplicationContext.class).profiles(new String[]{"foo"}).properties(new String[]{"foo=bar"});
        this.context = application.run(new String[0]);
        Assert.assertThat((Object)this.context, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StaticApplicationContext.class)));
        Assert.assertThat((Object)this.context.getEnvironment().getProperty("foo"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bucket")));
        Assert.assertThat((Object)this.context.getEnvironment().acceptsProfiles(new String[]{"foo"}), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void propertiesAsMap() throws Exception {
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[0]).sources(new Class[]{ExampleConfig.class}).contextClass(StaticApplicationContext.class).properties(Collections.singletonMap("bar", "foo"));
        this.context = application.run(new String[0]);
        Assert.assertThat((Object)this.context.getEnvironment().getProperty("bar"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"foo")));
    }

    @Test
    public void propertiesAsProperties() throws Exception {
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[0]).sources(new Class[]{ExampleConfig.class}).contextClass(StaticApplicationContext.class).properties(StringUtils.splitArrayElementsIntoProperties((String[])new String[]{"bar=foo"}, (String)"="));
        this.context = application.run(new String[0]);
        Assert.assertThat((Object)this.context.getEnvironment().getProperty("bar"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"foo")));
    }

    @Test
    public void specificApplicationContextClass() throws Exception {
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[0]).sources(new Class[]{ExampleConfig.class}).contextClass(StaticApplicationContext.class);
        this.context = application.run(new String[0]);
        Assert.assertThat((Object)this.context, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StaticApplicationContext.class)));
    }

    @Test
    public void parentContextCreation() throws Exception {
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[]{ChildConfig.class}).contextClass(SpyApplicationContext.class);
        application.parent(new Object[]{ExampleConfig.class});
        this.context = application.run(new String[0]);
        ((ConfigurableApplicationContext)Mockito.verify((Object)((SpyApplicationContext)this.context).getApplicationContext())).setParent((ApplicationContext)org.mockito.Matchers.any(ApplicationContext.class));
    }

    @Test
    public void contextWithClassLoader() throws Exception {
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[]{ExampleConfig.class}).contextClass(SpyApplicationContext.class);
        URLClassLoader classLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        application.resourceLoader((ResourceLoader)new DefaultResourceLoader((ClassLoader)classLoader));
        this.context = application.run(new String[0]);
        Assert.assertThat((Object)((SpyApplicationContext)this.context).getClassLoader(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)classLoader)));
    }

    @Test
    public void parentContextWithClassLoader() throws Exception {
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[]{ChildConfig.class}).contextClass(SpyApplicationContext.class);
        URLClassLoader classLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        application.resourceLoader((ResourceLoader)new DefaultResourceLoader((ClassLoader)classLoader));
        application.parent(new Object[]{ExampleConfig.class});
        this.context = application.run(new String[0]);
        Assert.assertThat((Object)((SpyApplicationContext)this.context).getResourceLoader().getClassLoader(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)classLoader)));
    }

    @Test
    public void parentFirstCreation() throws Exception {
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[]{ExampleConfig.class}).child(new Object[]{ChildConfig.class});
        application.contextClass(SpyApplicationContext.class);
        this.context = application.run(new String[0]);
        ((ConfigurableApplicationContext)Mockito.verify((Object)((SpyApplicationContext)this.context).getApplicationContext())).setParent((ApplicationContext)org.mockito.Matchers.any(ApplicationContext.class));
    }

    @Test
    public void parentFirstCreationWithProfileAndDefaultArgs() throws Exception {
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[]{ExampleConfig.class}).profiles(new String[]{"node"}).properties(new String[]{"transport=redis"}).child(new Object[]{ChildConfig.class}).web(false);
        this.context = application.run(new String[0]);
        Assert.assertThat((Object)this.context.getEnvironment().acceptsProfiles(new String[]{"node"}), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.context.getEnvironment().getProperty("transport"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"redis")));
        Assert.assertThat((Object)this.context.getParent().getEnvironment().acceptsProfiles(new String[]{"node"}), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.context.getParent().getEnvironment().getProperty("transport"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"redis")));
        Assert.assertThat((Object)this.context.getEnvironment().getProperty("bar"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"spam")));
    }

    @Test
    public void parentContextIdentical() throws Exception {
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[]{ExampleConfig.class});
        application.parent(new Object[]{ExampleConfig.class});
        application.contextClass(SpyApplicationContext.class);
        this.context = application.run(new String[0]);
        ((ConfigurableApplicationContext)Mockito.verify((Object)((SpyApplicationContext)this.context).getApplicationContext())).setParent((ApplicationContext)org.mockito.Matchers.any(ApplicationContext.class));
    }

    @Test
    public void initializersCreatedOnce() throws Exception {
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[]{ExampleConfig.class}).web(false);
        this.context = application.run(new String[0]);
        Assert.assertEquals((long)7L, (long)application.application().getInitializers().size());
    }

    public static class SpyApplicationContext
    extends AnnotationConfigApplicationContext {
        private ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)Mockito.spy((Object)new AnnotationConfigApplicationContext());
        private ResourceLoader resourceLoader;

        public void setParent(ApplicationContext parent) {
            this.applicationContext.setParent(parent);
        }

        public ConfigurableApplicationContext getApplicationContext() {
            return this.applicationContext;
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            super.setResourceLoader(resourceLoader);
            this.resourceLoader = resourceLoader;
        }

        public ResourceLoader getResourceLoader() {
            return this.resourceLoader;
        }
    }

    @Configuration
    static class ChildConfig {
        ChildConfig() {
        }
    }

    @Configuration
    static class ExampleConfig {
        ExampleConfig() {
        }
    }
}

