/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.config;

import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.config.YamlProcessor;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class YamlProcessorTests {
    private YamlProcessor processor = new YamlProcessor();

    @Test
    public void arrayConvertedToIndexedBeanReference() {
        this.processor.setResources(new Resource[]{new ByteArrayResource("foo: bar\nbar: [1,2,3]".getBytes())});
        this.processor.process(new YamlProcessor.MatchCallback(){

            public void process(Properties properties, Map<String, Object> map) {
                Assert.assertEquals((Object)1, (Object)properties.get("bar[0]"));
                Assert.assertEquals((Object)2, (Object)properties.get("bar[1]"));
                Assert.assertEquals((Object)3, (Object)properties.get("bar[2]"));
                Assert.assertEquals((long)4L, (long)properties.size());
            }
        });
    }

    @Test
    public void mapConvertedToIndexedBeanReference() {
        this.processor.setResources(new Resource[]{new ByteArrayResource("foo: bar\nbar:\n spam: bucket".getBytes())});
        this.processor.process(new YamlProcessor.MatchCallback(){

            public void process(Properties properties, Map<String, Object> map) {
                Assert.assertEquals((Object)"bucket", (Object)properties.get("bar.spam"));
                Assert.assertEquals((long)2L, (long)properties.size());
            }
        });
    }
}

