/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.config;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.boot.config.YamlProcessor;
import org.springframework.boot.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.Yaml;

public class YamlPropertiesFactoryBeanTests {
    @Test
    public void testLoadResource() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam:\n  foo: baz".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertEquals((Object)"bar", (Object)properties.get("foo"));
        Assert.assertEquals((Object)"baz", (Object)properties.get("spam.foo"));
    }

    @Test
    public void testLoadResourcesWithOverride() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam:\n  foo: baz".getBytes()), new ByteArrayResource("foo:\n  bar: spam".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertEquals((Object)"bar", (Object)properties.get("foo"));
        Assert.assertEquals((Object)"baz", (Object)properties.get("spam.foo"));
        Assert.assertEquals((Object)"spam", (Object)properties.get("foo.bar"));
    }

    @Test
    @Ignore
    public void testLoadResourcesWithInternalOverride() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam:\n  foo: baz\nfoo: bucket".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertEquals((Object)"bar", (Object)properties.get("foo"));
    }

    @Test
    @Ignore
    public void testLoadResourcesWithNestedInternalOverride() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo:\n  bar: spam\n  foo: baz\nbreak: it\nfoo: bucket".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertEquals((Object)"spam", (Object)properties.get("foo.bar"));
    }

    @Test
    public void testLoadResourceWithMultipleDocuments() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam: baz\n---\nfoo: bag".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertEquals((Object)"bag", (Object)properties.get("foo"));
        Assert.assertEquals((Object)"baz", (Object)properties.get("spam"));
    }

    @Test
    public void testLoadResourceWithSelectedDocuments() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam: baz\n---\nfoo: bag\nspam: bad".getBytes())});
        factory.setDocumentMatchers(Arrays.asList(new YamlProcessor.DocumentMatcher(){

            public YamlProcessor.MatchStatus matches(Properties properties) {
                return "bag".equals(properties.getProperty("foo")) ? YamlProcessor.MatchStatus.FOUND : YamlProcessor.MatchStatus.NOT_FOUND;
            }
        }));
        Properties properties = factory.getObject();
        Assert.assertEquals((Object)"bag", (Object)properties.get("foo"));
        Assert.assertEquals((Object)"bad", (Object)properties.get("spam"));
    }

    @Test
    public void testLoadResourceWithDefaultMatch() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setMatchDefault(true);
        factory.setResources(new Resource[]{new ByteArrayResource("one: two\n---\nfoo: bar\nspam: baz\n---\nfoo: bag\nspam: bad".getBytes())});
        factory.setDocumentMatchers(Arrays.asList(new YamlProcessor.DocumentMatcher(){

            public YamlProcessor.MatchStatus matches(Properties properties) {
                if (!properties.containsKey("foo")) {
                    return YamlProcessor.MatchStatus.ABSTAIN;
                }
                return "bag".equals(properties.getProperty("foo")) ? YamlProcessor.MatchStatus.FOUND : YamlProcessor.MatchStatus.NOT_FOUND;
            }
        }));
        Properties properties = factory.getObject();
        Assert.assertEquals((Object)"bag", (Object)properties.get("foo"));
        Assert.assertEquals((Object)"bad", (Object)properties.get("spam"));
        Assert.assertEquals((Object)"two", (Object)properties.get("one"));
    }

    @Test
    public void testLoadResourceWithDefaultMatchSkippingMissedMatch() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setMatchDefault(true);
        factory.setResources(new Resource[]{new ByteArrayResource("one: two\n---\nfoo: bag\nspam: bad\n---\nfoo: bar\nspam: baz".getBytes())});
        factory.setDocumentMatchers(Arrays.asList(new YamlProcessor.DocumentMatcher(){

            public YamlProcessor.MatchStatus matches(Properties properties) {
                if (!properties.containsKey("foo")) {
                    return YamlProcessor.MatchStatus.ABSTAIN;
                }
                return "bag".equals(properties.getProperty("foo")) ? YamlProcessor.MatchStatus.FOUND : YamlProcessor.MatchStatus.NOT_FOUND;
            }
        }));
        Properties properties = factory.getObject();
        Assert.assertEquals((Object)"bag", (Object)properties.get("foo"));
        Assert.assertEquals((Object)"bad", (Object)properties.get("spam"));
        Assert.assertEquals((Object)"two", (Object)properties.get("one"));
    }

    @Test
    public void testLoadNonExistentResource() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResolutionMethod(YamlProcessor.ResolutionMethod.OVERRIDE_AND_IGNORE);
        factory.setResources(new Resource[]{new ClassPathResource("no-such-file.yml")});
        Properties properties = factory.getObject();
        Assert.assertEquals((long)0L, (long)properties.size());
    }

    @Test
    public void testLoadNull() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam:".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertEquals((Object)"bar", (Object)properties.get("foo"));
        Assert.assertEquals((Object)"", (Object)properties.get("spam"));
    }

    @Test
    public void testLoadArrayOfString() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo:\n- bar\n- baz".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertEquals((Object)"bar", (Object)properties.get("foo[0]"));
        Assert.assertEquals((Object)"baz", (Object)properties.get("foo[1]"));
    }

    @Test
    public void testLoadArrayOfObject() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo:\n- bar:\n    spam: crap\n- baz\n- one: two\n  three: four".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertEquals((Object)"crap", (Object)properties.get("foo[0].bar.spam"));
        Assert.assertEquals((Object)"baz", (Object)properties.get("foo[1]"));
        Assert.assertEquals((Object)"two", (Object)properties.get("foo[2].one"));
        Assert.assertEquals((Object)"four", (Object)properties.get("foo[2].three"));
    }

    @Test
    public void testYaml() {
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.loadAs("foo: bar\nspam:\n  foo: baz", Map.class);
        Assert.assertEquals((Object)"bar", map.get("foo"));
        Assert.assertEquals((Object)"baz", ((Map)map.get("spam")).get("foo"));
    }
}

