/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactoryTests;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;

public class TomcatEmbeddedServletContainerFactoryTests
extends AbstractEmbeddedServletContainerFactoryTests {
    protected TomcatEmbeddedServletContainerFactory getFactory() {
        return new TomcatEmbeddedServletContainerFactory();
    }

    @Test
    public void tomcatListeners() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        LifecycleListener[] listeners = new LifecycleListener[4];
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i] = (LifecycleListener)Mockito.mock(LifecycleListener.class);
        }
        factory.setContextLifecycleListeners(Arrays.asList(listeners[0], listeners[1]));
        factory.addContextLifecycleListeners(new LifecycleListener[]{listeners[2], listeners[3]});
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        InOrder ordered = Mockito.inOrder((Object[])listeners);
        for (LifecycleListener listener : listeners) {
            ((LifecycleListener)ordered.verify((Object)listener)).lifecycleEvent((LifecycleEvent)Matchers.anyObject());
        }
    }

    @Test
    public void tomcatCustomizers() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        TomcatContextCustomizer[] listeners = new TomcatContextCustomizer[4];
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i] = (TomcatContextCustomizer)Mockito.mock(TomcatContextCustomizer.class);
        }
        factory.setTomcatContextCustomizers(Arrays.asList(listeners[0], listeners[1]));
        factory.addContextCustomizers(new TomcatContextCustomizer[]{listeners[2], listeners[3]});
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        InOrder ordered = Mockito.inOrder((Object[])listeners);
        for (TomcatContextCustomizer listener : listeners) {
            ((TomcatContextCustomizer)ordered.verify((Object)listener)).customize((Context)Matchers.anyObject());
        }
    }

    @Test
    public void tomcatConnectorCustomizers() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        TomcatConnectorCustomizer[] listeners = new TomcatConnectorCustomizer[4];
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i] = (TomcatConnectorCustomizer)Mockito.mock(TomcatConnectorCustomizer.class);
        }
        factory.setTomcatConnectorCustomizers(Arrays.asList(listeners[0], listeners[1]));
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{listeners[2], listeners[3]});
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        InOrder ordered = Mockito.inOrder((Object[])listeners);
        for (TomcatConnectorCustomizer listener : listeners) {
            ((TomcatConnectorCustomizer)ordered.verify((Object)listener)).customize((Connector)Matchers.anyObject());
        }
    }

    @Test
    public void sessionTimeout() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setSessionTimeout(10);
        this.assertTimeout(factory, 10);
    }

    @Test
    public void sessionTimeoutInMins() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setSessionTimeout(1, TimeUnit.MINUTES);
        this.assertTimeout(factory, 60);
    }

    private void assertTimeout(TomcatEmbeddedServletContainerFactory factory, int expected) {
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        Tomcat tomcat = ((TomcatEmbeddedServletContainer)this.container).getTomcat();
        Context context = (Context)tomcat.getHost().findChildren()[0];
        Assert.assertThat((Object)context.getSessionTimeout(), (Matcher)org.hamcrest.Matchers.equalTo((Object)expected));
    }
}

