/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.TestUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.stereotype.Component;

public class EnableConfigurationPropertiesTests {
    private AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();

    @Test
    public void testBasicPropertiesBinding() {
        this.context.register(new Class[]{TestConfiguration.class});
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "name:foo");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testNestedPropertiesBinding() {
        this.context.register(new Class[]{NestedConfiguration.class});
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "name:foo", "nested.name:bar");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(NestedProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((NestedProperties)this.context.getBean(NestedProperties.class)).name);
        Assert.assertEquals((Object)"bar", (Object)((NestedProperties)this.context.getBean(NestedProperties.class)).nested.name);
    }

    @Test
    public void testBasicPropertiesBindingWithAnnotationOnBaseClass() {
        this.context.register(new Class[]{DerivedConfiguration.class});
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "name:foo");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(DerivedProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((BaseProperties)this.context.getBean(BaseProperties.class)).name);
    }

    @Test
    public void testArrayPropertiesBinding() {
        this.context.register(new Class[]{TestConfiguration.class});
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "name:foo", "array:1,2,3");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((long)3L, (long)((TestProperties)this.context.getBean(TestProperties.class)).getArray().length);
    }

    @Test
    public void testCollectionPropertiesBindingFromYamlArray() {
        this.context.register(new Class[]{TestConfiguration.class});
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "name:foo", "list[0]:1", "list[1]:2");
        this.context.refresh();
        Assert.assertEquals((long)2L, (long)((TestProperties)this.context.getBean(TestProperties.class)).getList().size());
    }

    @Test
    public void testPropertiesBindingWithoutAnnotation() {
        this.context.register(new Class[]{MoreConfiguration.class});
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "name:foo");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(MoreProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((MoreProperties)this.context.getBean(MoreProperties.class)).name);
    }

    @Test
    public void testPropertiesBindingWithDefaultsInXml() {
        this.context.register(new Class[]{TestConfiguration.class, DefaultXmlConfiguration.class});
        this.context.refresh();
        String[] beanNames = this.context.getBeanNamesForType(TestProperties.class);
        Assert.assertEquals((String)("Wrong beans: " + Arrays.asList(beanNames)), (long)1L, (long)beanNames.length);
        Assert.assertEquals((Object)"bar", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testPropertiesBindingWithDefaultsInBeanMethod() {
        this.context.register(new Class[]{DefaultConfiguration.class});
        this.context.refresh();
        String[] beanNames = this.context.getBeanNamesForType(TestProperties.class);
        Assert.assertEquals((String)("Wrong beans: " + Arrays.asList(beanNames)), (long)1L, (long)beanNames.length);
        Assert.assertEquals((Object)"bar", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testBindingDirectlyToFile() {
        this.context.register(new Class[]{ResourceBindingProperties.class, TestConfiguration.class});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(ResourceBindingProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((ResourceBindingProperties)this.context.getBean(ResourceBindingProperties.class)).name);
    }

    @Test
    public void testBindingDirectlyToFileResolvedFromEnvironment() {
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "binding.location:classpath:other.yml");
        this.context.register(new Class[]{ResourceBindingProperties.class, TestConfiguration.class});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(ResourceBindingProperties.class).length);
        Assert.assertEquals((Object)"other", (Object)((ResourceBindingProperties)this.context.getBean(ResourceBindingProperties.class)).name);
    }

    @Test
    public void testBindingDirectlyToFileWithDefaultsWhenProfileNotFound() {
        this.context.register(new Class[]{ResourceBindingProperties.class, TestConfiguration.class});
        this.context.getEnvironment().addActiveProfile("nonexistent");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(ResourceBindingProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((ResourceBindingProperties)this.context.getBean(ResourceBindingProperties.class)).name);
    }

    @Test
    public void testBindingDirectlyToFileWithExplicitSpringProfile() {
        this.context.register(new Class[]{ResourceBindingProperties.class, TestConfiguration.class});
        this.context.getEnvironment().addActiveProfile("super");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(ResourceBindingProperties.class).length);
        Assert.assertEquals((Object)"bar", (Object)((ResourceBindingProperties)this.context.getBean(ResourceBindingProperties.class)).name);
    }

    @Test
    public void testBindingWithTwoBeans() {
        this.context.register(new Class[]{MoreConfiguration.class, TestConfiguration.class});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(MoreProperties.class).length);
    }

    @Test
    public void testBindingWithParentContext() {
        AnnotationConfigApplicationContext parent = new AnnotationConfigApplicationContext();
        parent.register(new Class[]{TestConfiguration.class});
        parent.refresh();
        TestUtils.addEnviroment((ConfigurableApplicationContext)this.context, "name:foo");
        this.context.setParent((ApplicationContext)parent);
        this.context.register(new Class[]{TestConfiguration.class, TestConsumer.class});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((long)1L, (long)parent.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestConsumer)this.context.getBean(TestConsumer.class)).getName());
    }

    @Test
    public void testBindingOnlyParentContext() {
        AnnotationConfigApplicationContext parent = new AnnotationConfigApplicationContext();
        TestUtils.addEnviroment((ConfigurableApplicationContext)parent, "name:foo");
        parent.register(new Class[]{TestConfiguration.class});
        parent.refresh();
        this.context.setParent((ApplicationContext)parent);
        this.context.register(new Class[]{TestConsumer.class});
        this.context.refresh();
        Assert.assertEquals((long)0L, (long)this.context.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((long)1L, (long)parent.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestConsumer)this.context.getBean(TestConsumer.class)).getName());
    }

    @ConfigurationProperties(path={"${binding.location:classpath:name.yml}"})
    protected static class ResourceBindingProperties {
        private String name;

        protected ResourceBindingProperties() {
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    protected static class MoreProperties {
        private String name;

        protected MoreProperties() {
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @ConfigurationProperties
    protected static class TestProperties {
        private String name;
        private int[] array;
        private List<Integer> list = new ArrayList<Integer>();

        protected TestProperties() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setArray(int ... values) {
            this.array = values;
        }

        public int[] getArray() {
            return this.array;
        }

        public List<Integer> getList() {
            return this.list;
        }
    }

    protected static class DerivedProperties
    extends BaseProperties {
        protected DerivedProperties() {
        }
    }

    @ConfigurationProperties
    protected static class BaseProperties {
        private String name;

        protected BaseProperties() {
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @ConfigurationProperties
    protected static class NestedProperties {
        private String name;
        private Nested nested = new Nested();

        protected NestedProperties() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public Nested getNested() {
            return this.nested;
        }

        protected static class Nested {
            private String name;

            protected Nested() {
            }

            public void setName(String name) {
                this.name = name;
            }
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={MoreProperties.class})
    protected static class MoreConfiguration {
        protected MoreConfiguration() {
        }
    }

    @Component
    protected static class TestConsumer {
        @Autowired
        private TestProperties properties;

        protected TestConsumer() {
        }

        @PostConstruct
        public void init() {
            Assert.assertNotNull((Object)this.properties);
        }

        public String getName() {
            return this.properties.name;
        }
    }

    @Configuration
    @ImportResource(value={"org/springframework/boot/context/properties/testProperties.xml"})
    protected static class DefaultXmlConfiguration {
        protected DefaultXmlConfiguration() {
        }
    }

    @Configuration
    protected static class DefaultConfiguration {
        protected DefaultConfiguration() {
        }

        @Bean
        public TestProperties testProperties() {
            TestProperties test = new TestProperties();
            test.setName("bar");
            return test;
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={NestedProperties.class})
    protected static class NestedConfiguration {
        protected NestedConfiguration() {
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={DerivedProperties.class})
    protected static class DerivedConfiguration {
        protected DerivedConfiguration() {
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={TestProperties.class})
    protected static class TestConfiguration {
        protected TestConfiguration() {
        }
    }
}

