/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j;

import org.apache.commons.logging.impl.Log4JLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.boot.OutputCapture;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.log4j.Log4JLoggingSystem;
import org.springframework.util.StringUtils;

public class Log4JLoggingSystemTests {
    @Rule
    public OutputCapture output = new OutputCapture();
    private Log4JLoggingSystem loggingSystem = new Log4JLoggingSystem(this.getClass().getClassLoader());
    private Log4JLogger logger;

    @Before
    public void setup() {
        this.logger = new Log4JLogger(this.getClass().getName());
    }

    @After
    public void clear() {
        System.clearProperty("LOG_FILE");
        System.clearProperty("LOG_PATH");
        System.clearProperty("PID");
    }

    @Test
    public void testNonDefaultConfigLocation() throws Exception {
        this.loggingSystem.initialize("classpath:log4j-nondefault.properties");
        this.logger.info((Object)"Hello world");
        String output = this.output.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("Hello world"));
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("/tmp/spring.log"));
    }

    @Test(expected=IllegalStateException.class)
    public void testNonexistentConfigLocation() throws Exception {
        this.loggingSystem.initialize("classpath:log4j-nonexistent.xml");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullConfigLocation() throws Exception {
        this.loggingSystem.initialize(null);
    }

    @Test
    public void setLevel() throws Exception {
        this.loggingSystem.initialize();
        this.logger.debug((Object)"Hello");
        this.loggingSystem.setLogLevel("org.springframework.boot", LogLevel.DEBUG);
        this.logger.debug((Object)"Hello");
        Assert.assertThat((Object)StringUtils.countOccurrencesOf((String)this.output.toString(), (String)"Hello"), (Matcher)Matchers.equalTo((Object)1));
    }
}

