/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;

public class PropertySourcesLoader {
    private final MutablePropertySources propertySources;
    private final List<PropertySourceLoader> loaders;

    public PropertySourcesLoader() {
        this(new MutablePropertySources());
    }

    public PropertySourcesLoader(MutablePropertySources propertySources) {
        Assert.notNull((Object)propertySources, (String)"PropertySources must not be null");
        this.propertySources = propertySources;
        this.loaders = SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, null);
    }

    public PropertySource<?> load(Resource resource, String name, String profile) throws IOException {
        if (resource != null && resource.exists()) {
            name = this.generatePropertySourceName(resource, name, profile);
            for (PropertySourceLoader loader : this.loaders) {
                if (!this.canLoadFileExtension(loader, resource)) continue;
                PropertySource<?> source = loader.load(name, resource, profile);
                this.addPropertySource(source);
                return source;
            }
        }
        return null;
    }

    private String generatePropertySourceName(Resource resource, String name, String profile) {
        if (name == null) {
            name = resource.getDescription();
        }
        return profile == null ? name : name + "#" + profile;
    }

    private boolean canLoadFileExtension(PropertySourceLoader loader, Resource resource) {
        String filename = resource.getFilename().toLowerCase();
        for (String extension : loader.getFileExtensions()) {
            if (!filename.endsWith("." + extension.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void addPropertySource(PropertySource<?> propertySource) {
        if (propertySource != null) {
            this.propertySources.addLast(propertySource);
        }
    }

    public MutablePropertySources getPropertySources() {
        return this.propertySources;
    }

    public Set<String> getAllFileExtensions() {
        HashSet<String> fileExtensions = new HashSet<String>();
        for (PropertySourceLoader loader : this.loaders) {
            fileExtensions.addAll(Arrays.asList(loader.getFileExtensions()));
        }
        return fileExtensions;
    }
}

