/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.builder;

import org.springframework.boot.builder.ParentContextApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.Ordered;

public class ParentContextCloserApplicationListener
implements ApplicationListener<ParentContextApplicationContextInitializer.ParentContextAvailableEvent>,
Ordered {
    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public void onApplicationEvent(ParentContextApplicationContextInitializer.ParentContextAvailableEvent event) {
        this.maybeInstallListenerInParent(event.getApplicationContext());
    }

    private void maybeInstallListenerInParent(ConfigurableApplicationContext child) {
        if (child.getParent() instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext parent = (ConfigurableApplicationContext)child.getParent();
            parent.addApplicationListener((ApplicationListener)new ContextCloserListener(child));
        }
    }

    protected static class ContextCloserListener
    implements ApplicationListener<ContextClosedEvent> {
        private ConfigurableApplicationContext context;

        public ContextCloserListener(ConfigurableApplicationContext context) {
            this.context = context;
        }

        public void onApplicationEvent(ContextClosedEvent event) {
            if (this.context != null && event.getApplicationContext() == this.context.getParent() && this.context.isActive()) {
                this.context.close();
            }
        }
    }
}

