/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.boot.context.embedded.ExampleFilter;
import org.springframework.boot.context.embedded.ExampleServlet;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.concurrent.ListenableFuture;

public abstract class AbstractEmbeddedServletContainerFactoryTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    protected EmbeddedServletContainer container;

    @After
    public void teardown() {
        if (this.container != null) {
            try {
                this.container.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void startServlet() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{this.exampleServletRegistration()});
        this.container.start();
        Assert.assertThat((Object)this.getResponse("http://localhost:8080/hello"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"Hello World"));
    }

    @Test
    public void emptyServerWhenPortIsZero() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setPort(0);
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{this.exampleServletRegistration()});
        this.container.start();
        this.thrown.expect(IOException.class);
        this.getResponse("http://localhost:8080/hello");
    }

    @Test
    public void stopServlet() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{this.exampleServletRegistration()});
        this.container.start();
        this.container.stop();
        this.thrown.expect(IOException.class);
        this.getResponse("http://localhost:8080/hello");
    }

    @Test
    public void restartWithKeepAlive() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{this.exampleServletRegistration()});
        this.container.start();
        HttpComponentsAsyncClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsAsyncClientHttpRequestFactory();
        ListenableFuture response1 = clientHttpRequestFactory.createAsyncRequest(new URI("http://localhost:8080/hello"), HttpMethod.GET).executeAsync();
        Assert.assertThat((Object)((ClientHttpResponse)response1.get(10L, TimeUnit.SECONDS)).getRawStatusCode(), (Matcher)org.hamcrest.Matchers.equalTo((Object)200));
        this.container.stop();
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{this.exampleServletRegistration()});
        this.container.start();
        ListenableFuture response2 = clientHttpRequestFactory.createAsyncRequest(new URI("http://localhost:8080/hello"), HttpMethod.GET).executeAsync();
        Assert.assertThat((Object)((ClientHttpResponse)response2.get(10L, TimeUnit.SECONDS)).getRawStatusCode(), (Matcher)org.hamcrest.Matchers.equalTo((Object)200));
    }

    @Test
    public void startServletAndFilter() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{this.exampleServletRegistration(), new FilterRegistrationBean((Filter)new ExampleFilter(), new ServletRegistrationBean[0])});
        this.container.start();
        Assert.assertThat((Object)this.getResponse("http://localhost:8080/hello"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"[Hello World]"));
    }

    @Test
    public void startBlocksUntilReadyToServe() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        final Date[] date = new Date[1];
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{new ServletContextInitializer(){

            public void onStartup(ServletContext servletContext) throws ServletException {
                try {
                    Thread.sleep(500L);
                    date[0] = new Date();
                }
                catch (InterruptedException ex) {
                    throw new ServletException((Throwable)ex);
                }
            }
        }});
        this.container.start();
        Assert.assertThat((Object)date[0], (Matcher)org.hamcrest.Matchers.notNullValue());
    }

    @Test
    public void loadOnStartAfterContextIsInitialized() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        final InitCountingServlet servlet = new InitCountingServlet();
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{new ServletContextInitializer(){

            public void onStartup(ServletContext servletContext) throws ServletException {
                servletContext.addServlet("test", (Servlet)servlet).setLoadOnStartup(1);
            }
        }});
        Assert.assertThat((Object)servlet.getInitCount(), (Matcher)org.hamcrest.Matchers.equalTo((Object)0));
        this.container.start();
        Assert.assertThat((Object)servlet.getInitCount(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
    }

    @Test
    public void specificPort() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setPort(8081);
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{this.exampleServletRegistration()});
        this.container.start();
        Assert.assertThat((Object)this.getResponse("http://localhost:8081/hello"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"Hello World"));
        Assert.assertEquals((long)8081L, (long)this.container.getPort());
    }

    @Test
    public void specificContextRoot() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setContextPath("/say");
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{this.exampleServletRegistration()});
        this.container.start();
        Assert.assertThat((Object)this.getResponse("http://localhost:8080/say/hello"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"Hello World"));
    }

    @Test
    public void contextPathMustStartWithSlash() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("ContextPath must start with '/ and not end with '/'");
        this.getFactory().setContextPath("missingslash");
    }

    @Test
    public void contextPathMustNotEndWithSlash() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("ContextPath must start with '/ and not end with '/'");
        this.getFactory().setContextPath("extraslash/");
    }

    @Test
    public void contextRootPathMustNotBeSlash() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Root ContextPath must be specified using an empty string");
        this.getFactory().setContextPath("/");
    }

    @Test
    public void doubleStop() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{this.exampleServletRegistration()});
        this.container.start();
        this.container.stop();
        this.container.stop();
    }

    @Test
    public void multipleConfigurations() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        ServletContextInitializer[] initializers = new ServletContextInitializer[6];
        for (int i = 0; i < initializers.length; ++i) {
            initializers[i] = (ServletContextInitializer)Mockito.mock(ServletContextInitializer.class);
        }
        factory.setInitializers(Arrays.asList(initializers[2], initializers[3]));
        factory.addInitializers(new ServletContextInitializer[]{initializers[4], initializers[5]});
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{initializers[0], initializers[1]});
        this.container.start();
        InOrder ordered = Mockito.inOrder((Object[])initializers);
        for (ServletContextInitializer initializer : initializers) {
            ((ServletContextInitializer)ordered.verify((Object)initializer)).onStartup((ServletContext)Matchers.anyObject());
        }
    }

    @Test
    public void documentRoot() throws Exception {
        FileCopyUtils.copy((String)"test", (Writer)new FileWriter(this.temporaryFolder.newFile("test.txt")));
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setDocumentRoot(this.temporaryFolder.getRoot());
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        this.container.start();
        Assert.assertThat((Object)this.getResponse("http://localhost:8080/test.txt"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"test"));
    }

    @Test
    public void mimeType() throws Exception {
        FileCopyUtils.copy((String)"test", (Writer)new FileWriter(this.temporaryFolder.newFile("test.xxcss")));
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setDocumentRoot(this.temporaryFolder.getRoot());
        MimeMappings mimeMappings = new MimeMappings();
        mimeMappings.add("xxcss", "text/css");
        factory.setMimeMappings(mimeMappings);
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        this.container.start();
        ClientHttpResponse response = this.getClientResponse("http://localhost:8080/test.xxcss");
        Assert.assertThat((Object)response.getHeaders().getContentType().toString(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"text/css"));
        response.close();
    }

    @Test
    public void errorPage() throws Exception {
        AbstractEmbeddedServletContainerFactory factory = this.getFactory();
        factory.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/hello")});
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[]{this.exampleServletRegistration(), this.errorServletRegistration()});
        this.container.start();
        Assert.assertThat((Object)this.getResponse("http://localhost:8080/hello"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"Hello World"));
        Assert.assertThat((Object)this.getResponse("http://localhost:8080/bang"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"Hello World"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResponse(String url) throws IOException, URISyntaxException {
        ClientHttpResponse response = this.getClientResponse(url);
        try {
            String string = StreamUtils.copyToString((InputStream)response.getBody(), (Charset)Charset.forName("UTF-8"));
            return string;
        }
        finally {
            response.close();
        }
    }

    protected ClientHttpResponse getClientResponse(String url) throws IOException, URISyntaxException {
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        ClientHttpRequest request = clientHttpRequestFactory.createRequest(new URI(url), HttpMethod.GET);
        ClientHttpResponse response = request.execute();
        return response;
    }

    protected abstract AbstractEmbeddedServletContainerFactory getFactory();

    private ServletContextInitializer exampleServletRegistration() {
        return new ServletRegistrationBean((Servlet)new ExampleServlet(), new String[]{"/hello"});
    }

    private ServletContextInitializer errorServletRegistration() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new ExampleServlet(){

            @Override
            public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                throw new RuntimeException("Planned");
            }
        }, new String[]{"/bang"});
        bean.setName("error");
        return bean;
    }

    private static class InitCountingServlet
    extends GenericServlet {
        private int initCount;

        private InitCountingServlet() {
        }

        public void init() throws ServletException {
            ++this.initCount;
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        }

        public int getInitCount() {
            return this.initCount;
        }
    }
}

