/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.boot.context.web.ErrorPageFilter;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ErrorPageFilterTests {
    private ErrorPageFilter filter = new ErrorPageFilter();
    private MockHttpServletRequest request = new MockHttpServletRequest();
    private MockHttpServletResponse response = new MockHttpServletResponse();
    private MockFilterChain chain = new MockFilterChain();

    @Test
    public void notAnError() throws Exception {
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.chain);
        Assert.assertThat((Object)this.chain.getRequest(), (Matcher)Matchers.equalTo((Object)this.request));
        Assert.assertThat((Object)((HttpServletResponseWrapper)this.chain.getResponse()).getResponse(), (Matcher)Matchers.equalTo((Object)this.response));
    }

    @Test
    public void globalError() throws Exception {
        this.filter.addErrorPages(new ErrorPage[]{new ErrorPage("/error")});
        this.chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                ((HttpServletResponse)response).sendError(400, "BAD");
                super.doFilter(request, response);
            }
        };
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.chain);
        Assert.assertThat((Object)((HttpServletResponseWrapper)this.chain.getResponse()).getStatus(), (Matcher)Matchers.equalTo((Object)400));
        Assert.assertThat((Object)this.request.getAttribute("javax.servlet.error.status_code"), (Matcher)Matchers.equalTo((Object)400));
        Assert.assertThat((Object)this.request.getAttribute("javax.servlet.error.message"), (Matcher)Matchers.equalTo((Object)"BAD"));
    }

    @Test
    public void statusError() throws Exception {
        this.filter.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.BAD_REQUEST, "/400")});
        this.chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                ((HttpServletResponse)response).sendError(400, "BAD");
                super.doFilter(request, response);
            }
        };
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.chain);
        Assert.assertThat((Object)((HttpServletResponseWrapper)this.chain.getResponse()).getStatus(), (Matcher)Matchers.equalTo((Object)400));
        Assert.assertThat((Object)this.request.getAttribute("javax.servlet.error.status_code"), (Matcher)Matchers.equalTo((Object)400));
        Assert.assertThat((Object)this.request.getAttribute("javax.servlet.error.message"), (Matcher)Matchers.equalTo((Object)"BAD"));
    }

    @Test
    public void exceptionError() throws Exception {
        this.filter.addErrorPages(new ErrorPage[]{new ErrorPage(RuntimeException.class, "/500")});
        this.chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                super.doFilter(request, response);
                throw new RuntimeException("BAD");
            }
        };
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.chain);
        Assert.assertThat((Object)((HttpServletResponseWrapper)this.chain.getResponse()).getStatus(), (Matcher)Matchers.equalTo((Object)500));
        Assert.assertThat((Object)this.request.getAttribute("javax.servlet.error.status_code"), (Matcher)Matchers.equalTo((Object)500));
        Assert.assertThat((Object)this.request.getAttribute("javax.servlet.error.message"), (Matcher)Matchers.equalTo((Object)"BAD"));
        Assert.assertThat((Object)this.request.getAttribute("javax.servlet.error.exception_type"), (Matcher)Matchers.equalTo((Object)RuntimeException.class.getName()));
    }

    @Test
    public void subClassExceptionError() throws Exception {
        this.filter.addErrorPages(new ErrorPage[]{new ErrorPage(RuntimeException.class, "/500")});
        this.chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                super.doFilter(request, response);
                throw new IllegalStateException("BAD");
            }
        };
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.chain);
        Assert.assertThat((Object)((HttpServletResponseWrapper)this.chain.getResponse()).getStatus(), (Matcher)Matchers.equalTo((Object)500));
        Assert.assertThat((Object)this.request.getAttribute("javax.servlet.error.status_code"), (Matcher)Matchers.equalTo((Object)500));
        Assert.assertThat((Object)this.request.getAttribute("javax.servlet.error.message"), (Matcher)Matchers.equalTo((Object)"BAD"));
        Assert.assertThat((Object)this.request.getAttribute("javax.servlet.error.exception_type"), (Matcher)Matchers.equalTo((Object)IllegalStateException.class.getName()));
    }
}

