/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.yaml;

import java.util.Map;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.boot.yaml.YamlProcessor;
import org.springframework.boot.yaml.YamlPropertiesFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.scanner.ScannerException;

public class YamlPropertiesFactoryBeanTests {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testLoadResource() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam:\n  foo: baz".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo"), (Matcher)Matchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)properties.getProperty("spam.foo"), (Matcher)Matchers.equalTo((Object)"baz"));
    }

    @Test
    public void testBadResource() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\ncd\nspam:\n  foo: baz".getBytes())});
        this.exception.expect(ScannerException.class);
        this.exception.expectMessage("line 3, column 1");
        factory.getObject();
    }

    @Test
    public void testLoadResourcesWithOverride() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam:\n  foo: baz".getBytes()), new ByteArrayResource("foo:\n  bar: spam".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo"), (Matcher)Matchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)properties.getProperty("spam.foo"), (Matcher)Matchers.equalTo((Object)"baz"));
        Assert.assertThat((Object)properties.getProperty("foo.bar"), (Matcher)Matchers.equalTo((Object)"spam"));
    }

    @Test
    @Ignore(value="We can't fail on duplicate keys because the Map is created by the YAML library")
    public void testLoadResourcesWithInternalOverride() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam:\n  foo: baz\nfoo: bucket".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo"), (Matcher)Matchers.equalTo((Object)"bar"));
    }

    @Test
    @Ignore(value="We can't fail on duplicate keys because the Map is created by the YAML library")
    public void testLoadResourcesWithNestedInternalOverride() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo:\n  bar: spam\n  foo: baz\nbreak: it\nfoo: bucket".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo.bar"), (Matcher)Matchers.equalTo((Object)"spam"));
    }

    @Test
    public void testLoadResourceWithMultipleDocuments() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam: baz\n---\nfoo: bag".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo"), (Matcher)Matchers.equalTo((Object)"bag"));
        Assert.assertThat((Object)properties.getProperty("spam"), (Matcher)Matchers.equalTo((Object)"baz"));
    }

    @Test
    public void testLoadResourceWithSelectedDocuments() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam: baz\n---\nfoo: bag\nspam: bad".getBytes())});
        factory.setDocumentMatchers(new YamlProcessor.DocumentMatcher[]{new YamlProcessor.DocumentMatcher(){

            public YamlProcessor.MatchStatus matches(Properties properties) {
                return "bag".equals(properties.getProperty("foo")) ? YamlProcessor.MatchStatus.FOUND : YamlProcessor.MatchStatus.NOT_FOUND;
            }
        }});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo"), (Matcher)Matchers.equalTo((Object)"bag"));
        Assert.assertThat((Object)properties.getProperty("spam"), (Matcher)Matchers.equalTo((Object)"bad"));
    }

    @Test
    public void testLoadResourceWithDefaultMatch() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setMatchDefault(true);
        factory.setResources(new Resource[]{new ByteArrayResource("one: two\n---\nfoo: bar\nspam: baz\n---\nfoo: bag\nspam: bad".getBytes())});
        factory.setDocumentMatchers(new YamlProcessor.DocumentMatcher[]{new YamlProcessor.DocumentMatcher(){

            public YamlProcessor.MatchStatus matches(Properties properties) {
                if (!properties.containsKey("foo")) {
                    return YamlProcessor.MatchStatus.ABSTAIN;
                }
                return "bag".equals(properties.getProperty("foo")) ? YamlProcessor.MatchStatus.FOUND : YamlProcessor.MatchStatus.NOT_FOUND;
            }
        }});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo"), (Matcher)Matchers.equalTo((Object)"bag"));
        Assert.assertThat((Object)properties.getProperty("spam"), (Matcher)Matchers.equalTo((Object)"bad"));
        Assert.assertThat((Object)properties.getProperty("one"), (Matcher)Matchers.equalTo((Object)"two"));
    }

    @Test
    public void testLoadResourceWithoutDefaultMatch() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setMatchDefault(false);
        factory.setResources(new Resource[]{new ByteArrayResource("one: two\n---\nfoo: bar\nspam: baz\n---\nfoo: bag\nspam: bad".getBytes())});
        factory.setDocumentMatchers(new YamlProcessor.DocumentMatcher[]{new YamlProcessor.DocumentMatcher(){

            public YamlProcessor.MatchStatus matches(Properties properties) {
                if (!properties.containsKey("foo")) {
                    return YamlProcessor.MatchStatus.ABSTAIN;
                }
                return "bag".equals(properties.getProperty("foo")) ? YamlProcessor.MatchStatus.FOUND : YamlProcessor.MatchStatus.NOT_FOUND;
            }
        }});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo"), (Matcher)Matchers.equalTo((Object)"bag"));
        Assert.assertThat((Object)properties.getProperty("spam"), (Matcher)Matchers.equalTo((Object)"bad"));
        Assert.assertThat((Object)properties.getProperty("one"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testLoadResourceWithDefaultMatchSkippingMissedMatch() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setMatchDefault(true);
        factory.setResources(new Resource[]{new ByteArrayResource("one: two\n---\nfoo: bag\nspam: bad\n---\nfoo: bar\nspam: baz".getBytes())});
        factory.setDocumentMatchers(new YamlProcessor.DocumentMatcher[]{new YamlProcessor.DocumentMatcher(){

            public YamlProcessor.MatchStatus matches(Properties properties) {
                if (!properties.containsKey("foo")) {
                    return YamlProcessor.MatchStatus.ABSTAIN;
                }
                return "bag".equals(properties.getProperty("foo")) ? YamlProcessor.MatchStatus.FOUND : YamlProcessor.MatchStatus.NOT_FOUND;
            }
        }});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo"), (Matcher)Matchers.equalTo((Object)"bag"));
        Assert.assertThat((Object)properties.getProperty("spam"), (Matcher)Matchers.equalTo((Object)"bad"));
        Assert.assertThat((Object)properties.getProperty("one"), (Matcher)Matchers.equalTo((Object)"two"));
    }

    @Test
    public void testLoadNonExistentResource() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResolutionMethod(YamlProcessor.ResolutionMethod.OVERRIDE_AND_IGNORE);
        factory.setResources(new Resource[]{new ClassPathResource("no-such-file.yml")});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testLoadNull() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo: bar\nspam:".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo"), (Matcher)Matchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)properties.getProperty("spam"), (Matcher)Matchers.equalTo((Object)""));
    }

    @Test
    public void testLoadArrayOfString() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo:\n- bar\n- baz".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo[0]"), (Matcher)Matchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)properties.getProperty("foo[1]"), (Matcher)Matchers.equalTo((Object)"baz"));
    }

    @Test
    public void testLoadArrayOfObject() throws Exception {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{new ByteArrayResource("foo:\n- bar:\n    spam: crap\n- baz\n- one: two\n  three: four".getBytes())});
        Properties properties = factory.getObject();
        Assert.assertThat((Object)properties.getProperty("foo[0].bar.spam"), (Matcher)Matchers.equalTo((Object)"crap"));
        Assert.assertThat((Object)properties.getProperty("foo[1]"), (Matcher)Matchers.equalTo((Object)"baz"));
        Assert.assertThat((Object)properties.getProperty("foo[2].one"), (Matcher)Matchers.equalTo((Object)"two"));
        Assert.assertThat((Object)properties.getProperty("foo[2].three"), (Matcher)Matchers.equalTo((Object)"four"));
    }

    @Test
    public void testYaml() {
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.loadAs("foo: bar\nspam:\n  foo: baz", Map.class);
        Assert.assertThat(map.get("foo"), (Matcher)Matchers.equalTo((Object)"bar"));
        Assert.assertThat(((Map)map.get("spam")).get("foo"), (Matcher)Matchers.equalTo((Object)"baz"));
    }
}

