/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context;

import org.junit.Assume;
import org.junit.Test;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.FileEncodingApplicationListener;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.test.EnvironmentTestUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;

public class FileEncodingApplicationListenerTests {
    private final FileEncodingApplicationListener initializer = new FileEncodingApplicationListener();
    private final ConfigurableEnvironment environment = new StandardEnvironment();
    private final ApplicationEnvironmentPreparedEvent event = new ApplicationEnvironmentPreparedEvent(new SpringApplication(new Object[0]), new String[0], this.environment);

    @Test(expected=IllegalStateException.class)
    public void testIllegalState() {
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.mandatory_file_encoding:FOO"});
        this.initializer.onApplicationEvent(this.event);
    }

    @Test
    public void testSunnyDayNothingMandated() {
        this.initializer.onApplicationEvent(this.event);
    }

    @Test
    public void testSunnyDayMandated() {
        Assume.assumeNotNull((Object[])new Object[]{System.getProperty("file.encoding")});
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.mandatory_file_encoding:" + System.getProperty("file.encoding")});
        this.initializer.onApplicationEvent(this.event);
    }
}

