/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.config.DelegatingApplicationListener;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.test.EnvironmentTestUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.annotation.Order;

public class DelegatingApplicationListenerTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final DelegatingApplicationListener listener = new DelegatingApplicationListener();
    private final StaticApplicationContext context = new StaticApplicationContext();

    @After
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void orderedInitialize() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"context.listener.classes:" + MockInitB.class.getName() + "," + MockInitA.class.getName()});
        this.listener.onApplicationEvent((ApplicationEvent)new ApplicationEnvironmentPreparedEvent(new SpringApplication(new Object[0]), new String[0], this.context.getEnvironment()));
        this.context.getBeanFactory().registerSingleton("testListener", (Object)this.listener);
        this.context.refresh();
        Assert.assertThat((Object)this.context.getBeanFactory().getSingleton("a"), (Matcher)Matchers.equalTo((Object)"a"));
        Assert.assertThat((Object)this.context.getBeanFactory().getSingleton("b"), (Matcher)Matchers.equalTo((Object)"b"));
    }

    @Test
    public void noInitializers() throws Exception {
        this.listener.onApplicationEvent((ApplicationEvent)new ApplicationEnvironmentPreparedEvent(new SpringApplication(new Object[0]), new String[0], this.context.getEnvironment()));
    }

    @Test
    public void emptyInitializers() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"context.listener.classes:"});
        this.listener.onApplicationEvent((ApplicationEvent)new ApplicationEnvironmentPreparedEvent(new SpringApplication(new Object[0]), new String[0], this.context.getEnvironment()));
    }

    @Order(value=0x7FFFFFFF)
    private static class MockInitB
    implements ApplicationListener<ContextRefreshedEvent> {
        private MockInitB() {
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)event.getApplicationContext();
            Assert.assertThat((Object)applicationContext.getBeanFactory().getSingleton("a"), (Matcher)Matchers.equalTo((Object)"a"));
            applicationContext.getBeanFactory().registerSingleton("b", (Object)"b");
        }
    }

    @Order(value=-2147483648)
    private static class MockInitA
    implements ApplicationListener<ContextRefreshedEvent> {
        private MockInitA() {
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)event.getApplicationContext();
            applicationContext.getBeanFactory().registerSingleton("a", (Object)"a");
        }
    }
}

