/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.AnnotationConfigEmbeddedWebApplicationContext;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.MockEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.MockServlet;
import org.springframework.boot.context.embedded.config.ExampleEmbeddedWebApplicationConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

public class AnnotationConfigEmbeddedWebApplicationContextTests {
    private AnnotationConfigEmbeddedWebApplicationContext context;

    @Test
    public void createFromScan() throws Exception {
        this.context = new AnnotationConfigEmbeddedWebApplicationContext(new String[]{ExampleEmbeddedWebApplicationConfiguration.class.getPackage().getName()});
        this.verifyContext();
    }

    @Test
    public void sessionScopeAvailable() throws Exception {
        this.context = new AnnotationConfigEmbeddedWebApplicationContext(new Class[]{ExampleEmbeddedWebApplicationConfiguration.class, SessionScopedComponent.class});
        this.verifyContext();
    }

    @Test
    public void sessionScopeAvailableToServlet() throws Exception {
        this.context = new AnnotationConfigEmbeddedWebApplicationContext(new Class[]{ExampleEmbeddedWebApplicationConfiguration.class, ExampleServletWithAutowired.class, SessionScopedComponent.class});
        Servlet servlet = (Servlet)this.context.getBean(ExampleServletWithAutowired.class);
        Assert.assertNotNull((Object)servlet);
    }

    @Test
    public void createFromConfigClass() throws Exception {
        this.context = new AnnotationConfigEmbeddedWebApplicationContext(new Class[]{ExampleEmbeddedWebApplicationConfiguration.class});
        this.verifyContext();
    }

    @Test
    public void registerAndRefresh() throws Exception {
        this.context = new AnnotationConfigEmbeddedWebApplicationContext();
        this.context.register(new Class[]{ExampleEmbeddedWebApplicationConfiguration.class});
        this.context.refresh();
        this.verifyContext();
    }

    @Test
    public void scanAndRefresh() throws Exception {
        this.context = new AnnotationConfigEmbeddedWebApplicationContext();
        this.context.scan(new String[]{ExampleEmbeddedWebApplicationConfiguration.class.getPackage().getName()});
        this.context.refresh();
        this.verifyContext();
    }

    @Test
    public void createAndInitializeCyclic() throws Exception {
        this.context = new AnnotationConfigEmbeddedWebApplicationContext(new Class[]{ServletContextAwareEmbeddedConfiguration.class});
        this.verifyContext();
        Assert.assertNull((Object)((ServletContextAwareEmbeddedConfiguration)this.context.getBean(ServletContextAwareEmbeddedConfiguration.class)).getServletContext());
    }

    @Test
    public void createAndInitializeWithParent() throws Exception {
        AnnotationConfigEmbeddedWebApplicationContext parent = new AnnotationConfigEmbeddedWebApplicationContext(new Class[]{EmbeddedContainerConfiguration.class});
        this.context = new AnnotationConfigEmbeddedWebApplicationContext();
        this.context.register(new Class[]{EmbeddedContainerConfiguration.class, ServletContextAwareConfiguration.class});
        this.context.setParent((ApplicationContext)parent);
        this.context.refresh();
        this.verifyContext();
        Assert.assertNotNull((Object)((ServletContextAwareConfiguration)this.context.getBean(ServletContextAwareConfiguration.class)).getServletContext());
    }

    private void verifyContext() {
        MockEmbeddedServletContainerFactory containerFactory = (MockEmbeddedServletContainerFactory)((Object)this.context.getBean(MockEmbeddedServletContainerFactory.class));
        Servlet servlet = (Servlet)this.context.getBean(Servlet.class);
        ((ServletContext)Mockito.verify((Object)containerFactory.getServletContext())).addServlet("servlet", servlet);
    }

    @Configuration
    @EnableWebMvc
    public static class ServletContextAwareConfiguration
    implements ServletContextAware {
        private ServletContext servletContext;

        @Bean
        public Servlet servlet() {
            return new MockServlet();
        }

        public void setServletContext(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }
    }

    @Configuration
    public static class EmbeddedContainerConfiguration {
        @Bean
        public EmbeddedServletContainerFactory containerFactory() {
            return new MockEmbeddedServletContainerFactory();
        }
    }

    @Configuration
    @EnableWebMvc
    public static class ServletContextAwareEmbeddedConfiguration
    implements ServletContextAware {
        private ServletContext servletContext;

        @Bean
        public EmbeddedServletContainerFactory containerFactory() {
            return new MockEmbeddedServletContainerFactory();
        }

        @Bean
        public Servlet servlet() {
            return new MockServlet();
        }

        public void setServletContext(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }
    }

    @Component
    @Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
    protected static class SessionScopedComponent {
        protected SessionScopedComponent() {
        }
    }

    @Component
    protected static class ExampleServletWithAutowired
    extends GenericServlet {
        @Autowired
        private SessionScopedComponent component;

        protected ExampleServletWithAutowired() {
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Assert.assertNotNull((Object)this.component);
        }
    }
}

