/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.boot.context.embedded.ServletListenerRegistrationBean;

public class ServletListenerRegistrationBeanTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final ServletContextListener listener = (ServletContextListener)Mockito.mock(ServletContextListener.class);
    @Mock
    private ServletContext servletContext;

    @Before
    public void setupMocks() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void startupWithDefaults() throws Exception {
        ServletListenerRegistrationBean bean = new ServletListenerRegistrationBean((EventListener)this.listener);
        bean.onStartup(this.servletContext);
        ((ServletContext)Mockito.verify((Object)this.servletContext)).addListener((EventListener)this.listener);
    }

    @Test
    public void disable() throws Exception {
        ServletListenerRegistrationBean bean = new ServletListenerRegistrationBean((EventListener)this.listener);
        bean.setEnabled(false);
        bean.onStartup(this.servletContext);
        ((ServletContext)Mockito.verify((Object)this.servletContext, (VerificationMode)Mockito.times((int)0))).addListener((EventListener)Matchers.any(ServletContextListener.class));
    }

    @Test
    public void cannotRegisterUnsupportedType() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Listener is not of a supported type");
        new ServletListenerRegistrationBean(new EventListener(){});
    }
}

